package cli

import (
	"log"
	"os"

	"github.com/spf13/cobra"
)

var RootCmd = &cobra.Command{
	Use:          "sqoverage",
	SilenceUsage: true,
	Short:        "",
	PersistentPreRunE: func(cmd *cobra.Command, args []string) error {
		return nil
	},
}

var configPath string

func Execute() {
	if err := RootCmd.Execute(); err != nil {
		log.Fatal(err)
		os.Exit(1)
	}
}

func init() {
	flags := RootCmd.PersistentFlags()
	flags.StringVar(&configPath, "config", "", "config file path")
	flags.Bool("ignore-cron", false, "one time run, instead of regular cron")
	flags.Bool("debug", false, "enable debug mode")
}
