package conductor

import (
	"io/ioutil"
	"log"
	"net/http"
	"strings"

	"a.yandex-team.ru/security/osquery/osquery-metrics/internal/sourceclient"
)

const (
	Name = "conductor"
)

type Source struct {
	ConductorURL string `yaml:"host"`
}

func (c *Source) FetchHosts() ([]string, error) {
	log.Printf("fetching for conductor\n")
	client := &http.Client{}
	req, err := http.NewRequest("GET", c.ConductorURL, nil)
	if err != nil {
		return nil, err
	}
	resp, err := client.Do(req)
	if err != nil {
		return nil, err
	}
	defer func() {
		err := resp.Body.Close()
		if err != nil {
			log.Fatal(err)
		}
	}()
	body, _ := ioutil.ReadAll(resp.Body)
	rawHosts := string(body)
	hosts := strings.Split(rawHosts, "\n")
	return hosts, nil
}

func (c *Source) GetSourceType() string {
	return Name
}

func NewClient() sourceclient.SourceClient {
	return &Source{"https://c.yandex-team.ru/api/projects2hosts/vertis"}
}
