package event

import "a.yandex-team.ru/security/osquery/osquery-metrics/internal/util"

type LogEntry interface {
	GetType() string
	GetJsonString() string
}

type SplunkEntry struct {
	SocTime    int64 `json:"time"`
	EventEntry Entry `json:"event"`
}

type Entry struct {
	ScanID      string `json:"scan_id"`
	Hostname    string `json:"hostname"`
	ServiceSlug string `json:"slug"`
	Source      string `json:"source"`
	Tag         string `json:"tag"`
	Responsible string `json:"responsible"`
}

func NewSplunkEntry(scanID string, hostname string, slug string, source string, tag string) *SplunkEntry {
	return &SplunkEntry{
		util.GetEpochTime(),
		Entry{
			scanID,
			hostname,
			slug,
			source,
			tag,
			"naumov-al",
		},
	}
}
