package handlers

import (
	"log"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/osquery/osquery-metrics/internal/config"
	"a.yandex-team.ru/security/osquery/osquery-metrics/internal/resulter"
)

func Coverage(ctx echo.Context) error {
	cc := ctx.(*config.Context)
	s := ctx.Param("service")
	cfg := cc.GetConfig()
	cptr := cfg.RuntimeCache
	p := ctx.Path()
	resp, cacheErr := cptr.Get(p)
	if cacheErr == nil {
		return ctx.JSON(http.StatusOK, resp)
	}
	services := cfg.Services
	for _, service := range services {
		if service.Slug == s {
			service.ConductorConf = &cfg.ConductorConf
			service.SplunkConf = &cfg.SplunkConf
			service.ComputeConf = &cfg.ComputeConf
			diffMap, err := service.GetMissingHosts()
			if err != nil {
				log.Printf("Unable to find missing hosts for %s service", service.Slug)
			}
			hecErr := resulter.SubmitReportToHEC(&cfg.GeneralConf, service, diffMap)
			handlerResp := resulter.CreateHandlerResponseJSON(&cfg.GeneralConf, service, diffMap, resulter.CoverageReportType)
			if hecErr != nil {
				log.Printf("Report error")
				return ctx.String(http.StatusOK, "")
			}
			setErr := cptr.Set(p, handlerResp)
			if setErr != nil {
				log.Printf("Unable to store to cache")
			}
			return ctx.JSON(http.StatusOK, handlerResp)
		}
	}
	return ctx.String(http.StatusOK, "Unable to check coverage")
}
