package enroll

import (
	"crypto/hmac"
	"crypto/sha256"
	"encoding/hex"
)

const (
	FakeEnrollNodeKeySecret = "DEADBEEF"
)

type Request struct {
	EnrollSecret   string                 `json:"enroll_secret"`
	HostIdentifier string                 `json:"host_identifier"`
	HostDetails    map[string]interface{} `json:"host_details"`
}

type Response struct {
	NodeKey     string `json:"node_key"`
	NodeInvalid bool   `json:"node_invalid,omitempty"`
}

// TODO(e-sidorov): do we need to include hostIdentifier?
func GenerateNodeKey(hmacSecret, enrollSecret, hostIdentifier string) string {
	h := hmac.New(sha256.New, []byte(hmacSecret))
	return hex.EncodeToString(h.Sum([]byte(enrollSecret)))
}

func CheckNodeKey(hmacSecret, enrollSecret, nodeKey string) bool {
	data, err := hex.DecodeString(nodeKey)
	if err != nil {
		return false
	}

	h := hmac.New(sha256.New, []byte(hmacSecret))
	result := h.Sum([]byte(enrollSecret))

	return hmac.Equal(result, data)
}
