package handlers

import (
	"net/http"
	"strconv"
	"strings"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/osquery/osquery-sender/util"
)

func ConnectionPeers(ctx echo.Context) error {
	var b strings.Builder
	for peer, count := range util.GetConnectionPeers() {
		b.WriteString(peer)
		b.WriteRune('\t')
		b.WriteString(strconv.Itoa(count))
		b.WriteRune('\n')
	}
	return ctx.String(http.StatusOK, b.String())
}

func RequestPeers(ctx echo.Context) error {
	var b strings.Builder
	for peer, count := range util.GetRequestPeers() {
		b.WriteString(peer)
		b.WriteRune('\t')
		b.WriteString(strconv.Itoa(count))
		b.WriteRune('\n')
	}
	return ctx.String(http.StatusOK, b.String())
}
