package handlers

import (
	"net/http"

	"github.com/labstack/echo/v4"
	"go.uber.org/atomic"

	"a.yandex-team.ru/security/osquery/osquery-sender/metrics"
)

var (
	pingOk = atomic.NewBool(true)
)

func Ping(ctx echo.Context) error {
	metrics.IncomingRps.Inc()
	if pingOk.Load() {
		return ctx.String(http.StatusOK, "OK")
	} else {
		return ctx.String(http.StatusServiceUnavailable, "Terminating")
	}
}

func DisablePing() {
	pingOk.Store(false)
}
