package metrics

import (
	"sync"

	"github.com/HdrHistogram/hdrhistogram-go"
)

// RequestHistogram is a wrapper around hdrhistogram which calls Merge() and Rotate() automatically.
type RequestHistogram struct {
	inner *hdrhistogram.WindowedHistogram
	mu    sync.Mutex
}

func NewRequestHistogram() *RequestHistogram {
	return &RequestHistogram{
		inner: hdrhistogram.NewWindowed(requestHistogramCount, 0, maxRequestTime, 2),
	}
}

func (r *RequestHistogram) Add(t int64) {
	r.mu.Lock()
	defer r.mu.Unlock()
	_ = r.inner.Current.RecordValue(t)
}

func (r *RequestHistogram) StandardQuantiles() (int64, int64, int64) {
	r.mu.Lock()
	defer r.mu.Unlock()
	merged := r.inner.Merge()
	r.inner.Rotate()
	return merged.ValueAtPercentile(50), merged.ValueAtPercentile(95), merged.ValueAtPercentile(99)
}
