package metrics

import "go.uber.org/atomic"

// MaxValue is a high-watermark metric: Get() returns maximum value reported since the last Get().
type MaxValue struct {
	value atomic.Uint64
}

func (g *MaxValue) Report(v uint64) {
	for {
		cur := g.value.Load()
		if cur >= v {
			break
		}
		if g.value.CAS(cur, v) {
			break
		}
	}
}

func (g *MaxValue) Get() uint64 {
	return g.value.Swap(0)
}
