package metrics

import "runtime"

func ReportUnistat() [][]interface{} {
	var memstats runtime.MemStats
	runtime.ReadMemStats(&memstats)

	req50, req95, req99 := RequestTimeMillis.StandardQuantiles()
	size50, size95, size99 := RequestSizeMillis.StandardQuantiles()
	chLoads := getChWorkerLoads()
	chWorkerAverage, chWorkerMax := computeAverageMax(chLoads)
	s3Loads := getS3WorkerLoads()
	s3WorkerAverage, s3WorkerMax := computeAverageMax(s3Loads)
	kinesisLoads := getKinesisWorkerLoads()
	kinesisWorkerAverage, _ := computeAverageMax(kinesisLoads)
	kinesisReq50, kinesisReq95, kinesisReq99 := KinesisRequestTimeMillis.StandardQuantiles()

	return [][]interface{}{
		{"alive_ammx", 1},
		{"num_goroutines_ammx", runtime.NumGoroutine()},
		{"heap_size_ammx", memstats.HeapAlloc},
		{"heap_objects_ammx", memstats.HeapObjects},

		{"rps-incoming_summ", IncomingRps.Swap(0)},
		{"rps-outgoing_summ", OutgoingRps.Swap(0)},
		{"request-time-p50_ammx", req50},
		{"request-time-p95_ammx", req95},
		{"request-time-p99_ammx", req99},
		{"request-size-p50_ammx", size50},
		{"request-size-p95_ammx", size95},
		{"request-size-p99_ammx", size99},
		{"concurrent-connections_ammx", MaxConcurrentConnections.Get()},
		{"concurrent-requests_ammx", MaxConcurrentRequests.Get()},
		{"timeouted-concurrent-connections_summ", TimeoutedConcurrentConnections.Swap(0)},
		{"rejected-concurrent-connections_summ", RejectedConcurrentConnections.Swap(0)},
		{"rejected-concurrent-requests_summ", RejectedConcurrentRequests.Swap(0)},
		{"errors-incoming-parsing_summ", IncomingParsingErrors.Swap(0)},
		{"errors-outgoing_summ", OutgoingErrors.Swap(0)},
		{"errors-dropped-queue-timeout_summ", DroppedByQueueTimeout.Swap(0)},
		{"errors-dropped-push-attempts_summ", DroppedByPushAttempts.Swap(0)},
		{"errors-dropped-retire-time_summ", DroppedByRetireTime.Swap(0)},
		{"len-queue_summ", QueueLen.Get()},

		{"ch-len-queue_summ", ChQueueLen.Get()},
		{"ch-size-queue_summ", ChQueueMemorySize.Get()},
		{"ch-size-batcher_summ", ChBatcherMemorySize.Get()},
		{"ch-commits_summ", ChCommits.Swap(0)},
		{"ch-inserted-rows_summ", ChInsertedRows.Swap(0)},
		{"ch-average-worker-load_ammx", chWorkerAverage},
		{"ch-max-worker-load_ammx", chWorkerMax},
		{"ch-flushed-pressure_summ", ChFlushedDueToPressure.Swap(0)},
		{"ch-dropped-queue-full_summ", ChDroppedDueToFullQueue.Swap(0)},
		{"ch-dropped-memory-full_summ", ChDroppedDueToFullMemory.Swap(0)},
		{"ch-dropped-after-retries_summ", ChDroppedAfterRetries.Swap(0)},
		{"ch-failed-retries_summ", ChFailedRetries.Swap(0)},
		{"ch-failures-during-cleanup_summ", ChFailuresDuringCleanup.Swap(0)},
		{"ch-dropped-partitions_summ", ChDroppedPartitions.Swap(0)},
		{"ch-total-size_ammx", sumSizes(getChTableSizes())},
		{"ch-total-rows_ammx", sumSizes(getChTableRows())},

		{"s3-len-queue_summ", S3QueueLen.Get()},
		{"s3-size-queue_summ", S3QueueMemorySize.Get()},
		{"s3-size-batcher_summ", S3BatcherMemorySize.Get()},
		{"s3-writes_summ", S3Writes.Swap(0)},
		{"s3-part-writes_summ", S3PartWrites.Swap(0)},
		{"s3-written-bytes_summ", S3WrittenBytes.Swap(0)},
		{"s3-average-worker-load_ammx", s3WorkerAverage},
		{"s3-max-worker-load_ammx", s3WorkerMax},
		{"s3-flushed-pressure_summ", S3FlushedDueToPressure.Swap(0)},
		{"s3-dropped-queue-full_summ", S3DroppedDueToFullQueue.Swap(0)},
		{"s3-dropped-memory-full_summ", S3DroppedDueToFullMemory.Swap(0)},
		{"s3-dropped-after-retries_summ", S3DroppedAfterRetries.Swap(0)},
		{"s3-failed-retries_summ", S3FailedRetries.Swap(0)},
		{"s3-failures-during-merge_summ", S3FailuresDuringMerge.Swap(0)},
		{"s3-merges_summ", S3Merges.Swap(0)},
		{"s3-deletions_summ", S3Deletions.Swap(0)},
		{"s3-total-size_ammx", sumSizes(getS3FolderSizes())},
		{"s3-total-objects_ammx", sumSizes(getS3FolderObjects())},
		{"s3-merged-objects_ammx", S3MergedObjects.Load()},
		{"s3-merger-load_ammx", S3MergerLoad.Load()},

		{"kinesis-len-queue_summ", KinesisQueueLen.Get()},
		{"kinesis-records_summ", KinesisRecords.Load()},
		{"kinesis-request-time-p50_ammx", kinesisReq50},
		{"kinesis-request-time-p95_ammx", kinesisReq95},
		{"kinesis-request-time-p99_ammx", kinesisReq99},
		{"kinesis-errors_summ", KinesisErrors.Load()},
		{"kinesis-dropped-queue-full_summ", KinesisDroppedDueToFullQueue.Load()},
		{"kinesis-average-worker-load_ammx", kinesisWorkerAverage},

		{"syslog-total-messages_summ", sumSizes(getSyslogMessageCounts())},
		{"syslog-total-errors_summ", sumSizes(getSyslogErrorCounts())},
	}
}
