package s3

import (
	"context"

	awsRequest "github.com/aws/aws-sdk-go/aws/request"
	awsS3 "github.com/aws/aws-sdk-go/service/s3"
)

// S3Client is the smaller subset of the huge s3iface.S3API interface (used for mocking).
type S3Client interface {
	AbortMultipartUploadWithContext(context.Context, *awsS3.AbortMultipartUploadInput, ...awsRequest.Option) (*awsS3.AbortMultipartUploadOutput, error)
	CompleteMultipartUploadWithContext(context.Context, *awsS3.CompleteMultipartUploadInput, ...awsRequest.Option) (*awsS3.CompleteMultipartUploadOutput, error)
	CopyObjectWithContext(context.Context, *awsS3.CopyObjectInput, ...awsRequest.Option) (*awsS3.CopyObjectOutput, error)
	CreateMultipartUploadWithContext(context.Context, *awsS3.CreateMultipartUploadInput, ...awsRequest.Option) (*awsS3.CreateMultipartUploadOutput, error)
	DeleteObjectsWithContext(context.Context, *awsS3.DeleteObjectsInput, ...awsRequest.Option) (*awsS3.DeleteObjectsOutput, error)
	GetObjectWithContext(context.Context, *awsS3.GetObjectInput, ...awsRequest.Option) (*awsS3.GetObjectOutput, error)
	HeadObjectWithContext(context.Context, *awsS3.HeadObjectInput, ...awsRequest.Option) (*awsS3.HeadObjectOutput, error)
	ListObjectsV2WithContext(context.Context, *awsS3.ListObjectsV2Input, ...awsRequest.Option) (*awsS3.ListObjectsV2Output, error)
	PutObjectWithContext(context.Context, *awsS3.PutObjectInput, ...awsRequest.Option) (*awsS3.PutObjectOutput, error)
	UploadPartWithContext(context.Context, *awsS3.UploadPartInput, ...awsRequest.Option) (*awsS3.UploadPartOutput, error)
}
