package formats

import (
	"bufio"
	"time"

	"gopkg.in/mcuadros/go-syslog.v2/format"
)

// SimpleFormat is a simplification of format.Format.
// It groups various steps into just one function: ParseLogLine.
// You may use FormatAdapter when format.Format is needed.
type SimpleFormat interface {
	// ParseLogLine parses one log line
	ParseLogLine(logLine []byte) (format.LogParts, error)
}

// FormatAdapter implements format.Format
type FormatAdapter struct {
	SimpleFormat SimpleFormat
}

func (f *FormatAdapter) GetParser(line []byte) format.LogParser {
	return &logParserAdapter{
		line:         line,
		simpleFormat: f.SimpleFormat,
	}
}

func (f *FormatAdapter) GetSplitFunc() bufio.SplitFunc {
	return nil // not used
}

// logParserAdapter implements format.LogParser (needed to implement format.Format)
type logParserAdapter struct {
	line         []byte
	simpleFormat SimpleFormat
	result       format.LogParts
}

func (c *logParserAdapter) Parse() (err error) {
	c.result, err = c.simpleFormat.ParseLogLine(c.line)
	return
}

func (c *logParserAdapter) Dump() format.LogParts {
	return c.result
}

func (c *logParserAdapter) Location(location *time.Location) {
	// not used
}
