package parsers

import (
	"regexp"
	"time"

	"a.yandex-team.ru/security/osquery/osquery-sender/parser"
	"a.yandex-team.ru/security/osquery/osquery-sender/syslogparsing/formats"
	"a.yandex-team.ru/security/osquery/osquery-sender/syslogparsing/util"
)

// Mellanox (Cumulus) logs

var Cumulus = SyslogParser{
	Format:    formats.FormatFromRegex(cumulusRegex, formats.DateParserToGroupParsers(parseCumulusDate)),
	FillEvent: fillCumulusEvent,
}

var cumulusRegex = regexp.MustCompile(`(?P<Date>[\dT:+.-]+) (?P<Host>[\w-.]+) (?P<Process>[\w-]+)\[(?P<ProcessId>\d+)]: (?P<Message>.+)`)

func fillCumulusEvent(logParts *util.LogPartsWrapper, event *parser.ParsedEvent) {
	event.Data[ColumnsDataKey] = map[string]interface{}{
		"process":  logParts.GetString("Process"),
		"proc_id":  logParts.GetString("ProcessId"),
		"hostname": logParts.GetString("Host"),
		"message":  logParts.GetString("Message"),
		"time":     logParts.GetUnixTime("Time"),
	}
}

func parseCumulusDate(date string) (t time.Time, err error) {
	return time.Parse("2006-01-02T15:04:05.000000-07:00", date) // https://stackoverflow.com/q/25845172/1121497
}
