package parsers

import (
	"regexp"

	"a.yandex-team.ru/security/osquery/osquery-sender/parser"
	"a.yandex-team.ru/security/osquery/osquery-sender/syslogparsing/formats"
	"a.yandex-team.ru/security/osquery/osquery-sender/syslogparsing/util"
)

// Juniper standard logs

var JuniperStandard = SyslogParser{
	Format:    formats.StandardFormat,
	FillEvent: fillJuniperStandardEvent,
}

var tagInMessageRegex = regexp.MustCompile(`^([A-Z_]+)`)

func fillJuniperStandardEvent(logParts *util.LogPartsWrapper, event *parser.ParsedEvent) {
	message := logParts.GetString("Message")
	columns := map[string]interface{}{
		"time":     logParts.GetUnixTime("Time"),
		"hostname": logParts.GetString("Host"),
		"process":  logParts.GetString("Process"),
		"proc_id":  logParts.GetString("ProcessId"),
		"message":  message,
	}
	event.Data[ColumnsDataKey] = columns

	tag := tagInMessageRegex.FindString(message)
	if tag != "" {
		columns["tag"] = tag
		columns["message"] = message[len(tag)+2:] // we skip tag and ": "
	}
}
