package util

import (
	"reflect"
	"regexp"
	"strings"
	"unsafe"
)

func CopyString(s string) string {
	// See https://groups.google.com/g/golang-nuts/c/naMCI9Jt6Qg for discussion.
	var b []byte
	h := (*reflect.SliceHeader)(unsafe.Pointer(&b))
	h.Data = (*reflect.StringHeader)(unsafe.Pointer(&s)).Data
	h.Len = len(s)
	h.Cap = len(s)
	return string(b)
}

// GlobsToRegexp converts the glob patterns (only * are supported) into corresponding regexp which matches this
// one of patterns, e.g. ["a*b", "cd*"] => "a.*b|cd.*"
func GlobsToRegexp(globs []string) *regexp.Regexp {
	var quoted []string
	for _, glob := range globs {
		quoted = append(quoted, regexp.QuoteMeta(glob))
	}
	joinedQuoted := strings.Join(quoted, "|")
	replacedStar := strings.ReplaceAll(joinedQuoted, "\\*", ".*")
	return regexp.MustCompile("^(" + replacedStar + ")$")
}
