#!/bin/sh

tag_file='/etc/osquery.tag'
flags_file='/etc/osquery/osquery.flags'
conf_file='/etc/osquery/osquery.conf'
paths_file='/etc/osquery/osquery.conf.d/40_file_paths.conf'
decorator_file='/etc/osquery/osquery.conf.d/51_decorator.conf'
packs_file='/etc/osquery/osquery.conf.d/60_packs.conf'
sysd_dropin='/etc/osquery/limits/osquery-systemd-drop-in.service'
extensions_path='/usr/local/bin'
extensions_load='/etc/osquery/extensions.load'
extensions_sock='/var/osquery/osquery.em'

append_packs_after_line=2
append_paths_after_line=2
append_flags_after_line=1
append_shadow_paths_after_line=1

get_osquery_tag() {
    curl -s --retry 3 -H "Metadata-Flavor: Google" 'http://169.254.169.254/computeMetadata/v1/instance/attributes/osquery_tag'
}

get_instance_id () {
    curl -s --retry 3 -H "Metadata-Flavor: Google" 'http://169.254.169.254/computeMetadata/v1/instance/id'
}

get_environment() {
    local instance_id="${1:-$(get_instance_id)}"
    # local prefix="${instance_id:0:3}" - bashism
    local prefix="$(expr "x${instance_id}" : "x.\{,0\}\(.\{,3\}\)")"
    local _env="UKNWN"
    # env prefixes taken from https://bb.yandex-team.ru/projects/CLOUD/repos/cloud-go/browse/private-api/endpoint_ids
    case $prefix in
        fd8|btq|fhm|epd|ef3)
            _env="PROD"
            ;;
        fdv|b06|a7l|c8r|d9h)
            _env="PRE-PROD"
            ;;
        c2p|dfs|fsa|all|bl8)
            _env="TESTING"
            ;;
        dcp|cn8|cbq)
            _env="DEV"
            ;;
        *)
            _env="UKNWN"
            ;;
    esac
    echo "${_env}"
}

add_pack () {
    sed -i "$append_packs_after_line a \         \"$1\":\"/etc/osquery/packs/$2.conf\"," $packs_file
}

del_pack_by_name () {
    # deleting pack with any preceding comma
    # 1. set label - :a
    # 2. push next line to buffer - N
    # 3. replace on buffer
    # 4. repeat if any unprocessed lines in file
    sed -i -e ":a" -e "N" -Ee "s/,?\n\s*\"$1\": \".*?\"//g" -e '$!ba' $packs_file
}

# TODO: taken from junk, should polish in next release
# https://a.yandex-team.ru/arc/trunk/arcadia/junk/axlodin/PKGBUILDS/osquery-ycloud-workstations-config/PKGBUILD?rev=7234593#L30
__set_flag() {
	local file="$1"
	local flag="$2" # actually flag pattern
	local value="$3"
	local position="${4:-1}" # after which flag insert new flag
	
	if grep -qEe "--${flag}[\=\s].*?" "${file}";
	then
		sed -i -Ee "s/--${flag}([\s\=]+).*/--${flag}\1${value}/g" "${file}"
	else
	    sed -i -e "/--${position}/a\--${flag}=${value}" "${file}"
	fi
}

set_flag() {
   	local file="${flags_file}"
	local flag="$1" # actually flag pattern
	local value="$2"
	local position="${3:-disable_extensions}" # after which flag insert new flag

    __set_flag "${file}" "${flag}" "${value}" "${position}"
}

add_flag() {
    set_flag ""
}

false_flag () {
    set_flag "$1" "false"
}

enable_extension() {
    false_flag "disable_extensions"

    local ext_fullpath="${extensions_path}/$1.ext"
    if ! grep -Fxq "${ext_fullpath}" "${extensions_load}"; then
        echo "${extensions_path}/$1.ext" >> "${extensions_load}"
    fi
}

use_ycloud_fim() {
    if ! grep -q 'osquery-fim' "${extensions_load}";
    then
        del_pack_by_name integrity
        del_pack_by_name file

        set_flag "extensions_autoload" "${extensions_load}" "disable_extensions"
        enable_extension "osquery-fim"
        add_pack "yc-integrity" file_integrity_ycloud
    fi
}

set_tls_hostname() {
    set_flag "tls_hostname" "$1"
}

set_splunk_tag() {
    sed -i "s/\"SELECT .* AS tag;\"/\"SELECT '$1' AS tag;\"/g" "${decorator_file}"
}

# if used in xgen immutable image -> then replace tag 
if grep -q 'ycloud-svc-generic-config' /etc/osquery.tag; 
then
    # check if 404 not found
    NEW_TAG="$(get_osquery_tag)";
    if test -z "$NEW_TAG" 
    then
        :
    else
        set_splunk_tag "$NEW_TAG"
    fi

    environment="$(get_environment)"
    case $environment in
        DEV | TESTING | "PRE-PROD")
            use_ycloud_fim
            set_tls_hostname 'osquery.cloud.yandex.net'
            ;;
        PROD | *)
            set_tls_hostname 'cos.sec.yandex.net'
            ;;
    esac
fi
