#!/bin/sh

_need_cleanup() {
    # too old data files in db
    if /usr/bin/env find /usr/share/osquery/osquery.dbq/ -mindepth 1 -mtime +0 -type f \! \( -name "CURRENT" -o -name "IDENTITY" -o -name "LOCK" -o -name "MANIFEST-*" \) | grep -q '.'; then
        return 0;
    fi
    # too large db
    if [ $(du -k /usr/share/osquery/osquery.dbq/ | cut -f1) -ge 350000 ]; then
        return 0;
    fi
    # todo fastfix, change to caching all metrics to some file
    if [ -x /bin/systemctl ] && [ -x /run/systemd/system ] ; then
        # every 3th restart if systemd is new enough
        local nrestarts=$(/bin/systemctl show osqueryd -p NRestarts | cut -d'=' -f2)
        if [ $((${nrestarts:-1} % 3)) -eq 0 ]; then
            return 0;
        fi

        # if last start was less then 10 minutes ago ()
        local lastactivetms="$(/bin/systemctl show osqueryd -p ActiveEnterTimestamp | cut -d'=' -f2)"
        local lastactiveunix="$(date --date="${lastactivetms}" '+%s')"
        local currentunix="$(date '+%s')"
        if [ $((${currentunix} - ${lastactiveunix:-0})) -le 600 ]; then
            return 0;
        fi
    fi
    return 1
}

# database cleanup if needed
if _need_cleanup; then
    /usr/bin/env find /usr/share/osquery/osquery.dbq/ -type f -delete
    rm -rf /usr/share/osquery/osquery.dbq/* 2>/dev/null
fi

# mount tmpfs
/usr/bin/env sh -c 'test -x /etc/osquery/osqueryd-tmpfs.sh && /etc/osquery/osqueryd-tmpfs.sh mount'

if [ -d /etc/osquery/scripts/startup/ ]; then
    for x in /etc/osquery/scripts/startup/*.sh ; do
        if [ -x "${x}" ]; then
            /bin/sh "${x}"
        fi
    done
else
    /etc/osquery/osqueryd-startup-legacy.sh
fi
