#!/bin/sh

TMPFS_FILE="/etc/default/osqueryd.tmpfs"
TMPFS_PATH="/usr/share/osquery/osquery.dbq"

if [ ! -f "${TMPFS_FILE}" ]; then
   exit 0
fi

. "${TMPFS_FILE}"

if [ -z "${TMPFS_OPTS}" ]; then
   exit 0
fi

case "$1" in
   mount)
       if ! mountpoint -q "${TMPFS_PATH}"; then
           mount -t tmpfs -o "${TMPFS_OPTS}" tmpfs "${TMPFS_PATH}"
       fi
       ;;
   umount)
       if mountpoint -q "${TMPFS_PATH}"; then
          sleep 2
          if command -v fuser > /dev/null 2>&1; then
            fuser -k -9 "${TMPFS_PATH}"
          fi
          umount -f "${TMPFS_PATH}"
       fi
       ;;
   *)
       echo "$0 [mount|umount]"
       exit 1
       ;;
esac
