#!/bin/sh

# intentionally commented
# should fill all variables
# errors are allowed in some cases
# set -e

GLOBALS_PATH="${GLOBALS_PATH:-/etc/osquery/scripts/settings/globals.sh}"

. "${LIBS_PATH:-/etc/osquery/scripts/lib/lib.sh}"
. "${GLOBALS_PATH}"


set_global() {
    local key="$1"
    local value="$2"

    if ! grep -q "${key}=\"${value}\"" "${GLOBALS_PATH}"; then
        escaped_value=$(printf '%s\n' "${value}" | sed 's/\//\\\//g')
        sed -i "s/^${key}=\".*\"/${key}=\"${escaped_value}\"/g" "${GLOBALS_PATH}"
    fi
}

set -x

if [ "x${GLOBALS_READONLY}" = "x0" ]; then
    GLOBAL_METADATA_ENDPOINT="$(metadata_endpoint)"
    GLOBAL_INSTANCE_ID="$(get_instance_id)"
    GLOBAL_ENVIRONMENT="$(get_environment)"
    GLOBAL_LOCAL_TAG="$(echo $(cat ${tag_file}))"
    GLOBAL_OSQUERY_TAG="$(get_osquery_tag)"
    GLOBAL_OSQUERY_VERSION="$(osquery_version)"
    GLOBAL_YCLOUDMETA_AVAILABLE="$(osquery_table_exists ycloud_instance_metadata && echo 1 || echo 0)"

    set_global GLOBAL_METADATA_ENDPOINT "${GLOBAL_METADATA_ENDPOINT}"
    set_global GLOBAL_INSTANCE_ID "${GLOBAL_INSTANCE_ID}"
    set_global GLOBAL_ENVIRONMENT "${GLOBAL_ENVIRONMENT}"
    set_global GLOBAL_LOCAL_TAG "${GLOBAL_LOCAL_TAG}"
    set_global GLOBAL_OSQUERY_TAG "${GLOBAL_OSQUERY_TAG}"
    set_global GLOBAL_OSQUERY_VERSION "${GLOBAL_OSQUERY_VERSION}"
    set_global GLOBAL_YCLOUDMETA_AVAILABLE "${GLOBAL_YCLOUDMETA_AVAILABLE}"
fi
