#!/bin/sh

. "${LIBS_PATH:-/etc/osquery/scripts/lib/lib.sh}"
. "${GLOBALS_PATH:-/etc/osquery/scripts/settings/globals.sh}"

set -e

is_batched_events_max() {
    local ver_maj="$(version_major ${GLOBAL_OSQUERY_VERSION})"
    local ver_mid="$(version_middle ${GLOBAL_OSQUERY_VERSION})"

    if [ "${ver_maj}" -gt 4 ] || ( [ "${ver_maj}" -eq 4 ] && [ "${ver_mid}" -ge 7 ] ); then
        return 0;
    fi
    return 1;
}

set -x

# since osquery 4.7 eventing framework was rewritten
# previously events_max meant the maximum number of events in rocksdb
# now it is a max number of event batches, which are groups of events been processed on point of time. 
# The difference:
# SELECT count(*) AS events_cnt, count(DISTINCT time) AS batches_cnt FROM process_events; 
# https://osquery.slack.com/archives/C08V7KTJB/p1622484876086800
if is_batched_events_max; then
    # prohibit to ban precess_executions
    sed -i -Ee 's/"denylist"\s*:\s*(true|1),/"denylist": false,/' "${packs_path}/processes.conf"
    set_flag "events_max" 450
fi
