#!/bin/sh

set -e

. "${GLOBALS_PATH:-/etc/osquery/scripts/settings/globals.sh}"

CONFD_PATH=${CONFD_PATH:-/etc/osquery/osquery.conf.d}
CUSTOM_OPTS_PATH="${CUSTOM_OPTS_PATH:-${CONFD_PATH}/20_custom_options.conf}"
AWSMETADATA_DECORATOR_PATH="${AWSMETADATA_DECORATOR_PATH:-/etc/osquery/settings/decorators/52_decorator_awsmetadata.conf}"
UUIDMETADATA_DECORATOR_PATH="${UUIDMETADATA_DECORATOR_PATH:-/etc/osquery/settings/decorators/53_decorator_uuid.conf}"
YCMETADATA_DECORATOR_PATH="${YCMETADATA_DECORATOR_PATH:-/etc/osquery/settings/decorators/54_decorator_ycmetadata.conf}"

metadata_endpoint="${GLOBAL_METADATA_ENDPOINT}"

set -x

if [ -z "${metadata_endpoint}" ]; then
    case "${GLOBAL_LOCAL_TAG}" in
        ycloud-svc-generic-config | yandex-ycloud-config | ycloud-mdb-*)
            metadata_endpoint="http://169.254.169.254"
            ;;
        ycloud-svc*)
            metadata_endpoint="http://localhost:6770"
            ;;
        ycloud-hv*)
            metadata_endpoint=""
            ;;
        *)
            metadata_endpoint=""
            ;;
    esac
fi


ycmeta=0
awsmeta=0
uuid=0

if [ -n "${metadata_endpoint}" ] && [ "x${GLOBAL_YCLOUDMETA_AVAILABLE}" = "x1" ]; then
    sed_endpoint=$(printf '%s\n' "${metadata_endpoint}" | sed 's/\//\\\//g')
    sed -Ei "s/\"custom_ycmetadata_endpoint\"\s*:\s*\".*?\"/\"custom_ycmetadata_endpoint\": \"${sed_endpoint}\"/g" "${CUSTOM_OPTS_PATH}"
    sed -Ei "s/metadata_endpoint\s*=\s*'.*?'/metadata_endpoint = '${sed_endpoint}'/" "${YCMETADATA_DECORATOR_PATH}"

    ycmeta=1
    awsmeta=0
    uuid=0
elif [ "x${metadata_endpoint}" = "xhttp://169.254.169.254" ]; then
    ycmeta=0
    awsmeta=1
    uuid=0
else
    ycmeta=0
    awsmeta=0
    uuid=1
fi

link_of_unlink_decorator() {
    local create_or_delete_flag="$1"
    local source_file="$2"
    local target_link="${CONFD_PATH}/$(basename ${source_file})"

    if [ "x${create_or_delete_flag}" = "x1" ]; then
        if ! [ -e "${target_link}" ]; then
            ln -s "${source_file}" "${target_link}"
        fi
    else
        if [ -L "${target_link}" ]; then
            rm "${target_link}"
        fi
    fi
}

link_of_unlink_decorator $ycmeta "${YCMETADATA_DECORATOR_PATH}"
link_of_unlink_decorator $awsmeta "${AWSMETADATA_DECORATOR_PATH}"
link_of_unlink_decorator $uuid "${UUIDMETADATA_DECORATOR_PATH}"
