#!/bin/sh

set -e

. "${LIBS_PATH:-/etc/osquery/scripts/lib/lib.sh}"
. "${GLOBALS_PATH:-/etc/osquery/scripts/settings/globals.sh}"

use_ycloud_fim() {
    if ! grep -q 'osquery-fim' "${extensions_load}";
    then
        del_pack_by_name integrity
        del_pack_by_name file

        set_flag "extensions_autoload" "${extensions_load}" "disable_extensions"
        enable_extension "osquery-fim"
        add_pack "yc-integrity" file_integrity_ycloud
    fi
}

set -x

if [ "x${GLOBAL_LOCAL_TAG}" = 'xycloud-svc-generic-config' ]; then
    case "${GLOBAL_ENVIRONMENT}" in
        DEV | TESTING | "PRE-PROD" | "ISRAEL" | "*TESTING" | "PRIVATE-*" )
            use_ycloud_fim
            ;;
        PROD | *)
            case "${GLOBAL_OSQUERY_TAG}" in 
                "ycloud-svc-schecker" | "ycloud-svc-ai-config" )
                    use_ycloud_fim
                ;;
            esac
            ;;
    esac
fi
