#include <unistd.h>
#include <stdio.h>
#include <iostream>
#include <fstream>
#include <sys/wait.h>
#include <sys/ptrace.h>
#include <contrib/libs/porto_api/libporto.hpp>

void waitPortod(int pid) {
    while (true) {
        if (ptrace(PTRACE_ATTACH, pid, nullptr, nullptr) == -1) {
            continue;
        }

        std::cout << "Attached to portod with pid " << pid << std::endl;

        int ppid = getppid();
        std::string feezerPath = "/proc/" +  std::to_string(pid) + "/root/sys/fs/cgroup/freezer/tasks";
        std::ofstream freezer;
        freezer.open(feezerPath, std::ios::out | std::ios::app);
        if (freezer.fail()) {
            std::cerr << "failed to open '" << feezerPath << "': " << strerror(errno) << std::endl;
            break;
        }

        freezer << ppid;
        freezer.close();
        std::cout << "Put our parent (" << ppid << ") into root freezer cgroup: " << freezer.good() << std::endl;

        ptrace(PTRACE_CONT, pid, nullptr, nullptr);
        ptrace(PTRACE_DETACH, pid, nullptr, nullptr);
        std::cout << "Detached portod" << std::endl;;
        break;
    }
}

int main() {
    int targetPid = getpid() + 2;
    std::cout << "Wait for portod with pid " << targetPid << std::endl;

    int pid = fork();
    if (pid > 0) {
        waitPortod(targetPid);
        exit(0);
    } else {
        Cout << "Locale process " << Endl;
        Porto::Connection api;
        TString _ = "";
        Y_UNUSED(api.LocateProcess(getpid(), _, _))
    }
    waitpid(pid, nullptr, 0);
    sleep(2);
}
