#include <gst/gst.h>
#include <gst/net/gstnetclientclock.h>
#include <gst/net/gstnettimeprovider.h>

#include <mutex>
#include <stdexcept>
#include <string>
#include <signal.h>

namespace {
  std::function<void(int)> shutdown_handler;
  void signal_handler(int signal) { shutdown_handler(signal); }
}

int main() {
  std::mutex m;
  m.lock();

  shutdown_handler = [&](int signal) {
    Y_UNUSED(signal);
    m.unlock();
  };
  signal(SIGINT, signal_handler);

  auto gstClock = std::shared_ptr<GstClock>(gst_system_clock_obtain(), [](GstClock * p) { gst_object_unref(p); });
  if (!gstClock) {
    throw std::runtime_error("Fail to create time provider. Obtain system clock failed.");
  }

  auto gstNetTimeProvider_ = std::shared_ptr<GstNetTimeProvider>(
    gst_net_time_provider_new(gstClock.get(), nullptr, 11125),
    [](GstNetTimeProvider * p){ gst_object_unref(p); });

  m.lock();
}
