#!/bin/python
from __future__ import print_function
import random
import argparse
import requests
import logging
import re
try:
    from urllib import quote_plus as urlquote
except ImportError:
    from urllib.parse import quote_plus as urlquote


def parse_target(target):
    if 'monproxy' in target:
        if not target.startswith('https://'):
            return 'https://' + target
        return target

    if target.endswith('_0'):
        target = target[:-2]
    target = target.replace('-', '').replace('_', '')
    res = requests.get('https://%s.n.yandex-team.ru/host_list' % target)
    monitors = []
    for host in res.json():
        if len(host) > 1:
            link = host[0].get('link', '')
            if link:
                link = link.format(balancer='n')
                logging.info('got monitor at %s', link)
                monitors.append(link)

    target = random.choice(monitors)
    logging.info('pick %s monitor', target)
    return target


def get_proc(target):
    res = requests.get('%s/system_info/' % target)
    procs = []
    for proc in re.finditer(r'-liner-\s(?P<uuid>[^\s]+)\s(?P<name>[^\s]+)', res.text):
        name = proc.group('name')
        uuid = proc.group('uuid')
        if not uuid or uuid == 'service' or name in ['debugger', 'monitor', 'monproxy']:
            continue

        logging.info('found proc %s with uuid %s', name, uuid)
        procs.append((name, uuid))

    proc = random.choice(procs)
    logging.info('pick %s (%s) proc', *proc)
    return proc[1]


if __name__ == "__main__":
    logging.basicConfig(level=logging.INFO)

    parser = argparse.ArgumentParser()
    parser.add_argument('target', type=str, help='target service name or monitor')
    parser.add_argument('cmd', type=str, help='command to execute')

    args = parser.parse_args()
    cmd = args.cmd

    # get monitor uri
    target = parse_target(args.target)

    # pick up random proc uuid
    uuid = get_proc(target)

    # start debugger
    requests.get('%s/proc/%s/debug/' % (target, uuid))
    # wait promt
    while True:
        res = requests.get('%s/proc/%s/debug/data_portion/' % (target, uuid))
        if '(gdb)' in res.text:
            break

    # execute command
    ecmd = urlquote(urlquote(urlquote('shell %s\n' % cmd)))
    res = requests.get('%s/proc/%s&data=%s&/debug/data_portion/' % (target, uuid, ecmd))
    print(res.text, end='')
    while True:
        res = requests.get('%s/proc/%s/debug/data_portion/' % (target, uuid))
        out = res.text
        print(out, end='')
        if '(gdb)' in out:
            break

    # cleanup
    requests.get('%s/proc/%s&data=%s/debug/data_portion/' % (target, uuid, 'detach%25250a'))
    requests.get('%s/proc/%s&data=%s/debug/data_portion/' % (target, uuid, 'quit%25250a'))
