import os
import sys
import select
import socket
import time
import getpass
import paramiko
import tempfile
import msgpack
import threading
from argparse import ArgumentParser
from functools import partial


def listen_linear(socket_path, command):
    try:
        os.unlink(socket_path)
    except OSError:
        if os.path.exists(socket_path):
            raise

    sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
    sock.bind(socket_path)

    print('Linear listen on {}'.format(socket_path))

    sock.listen(1)

    try:
        while True:
            conn, addr = sock.accept()
            while True:
                data = conn.recv(4096)
                if not data:
                    continue

                print('incoming linear request: %s' % data)
                req = msgpack.loads(data)
                if req == 'terminatepg':
                    print('terminate request received')
                    raise Exception('stop')
                elif req == 'info':
                    conn.sendall(msgpack.dumps({
                        'version': 1,
                        'pid': None,
                        'pgid': None,
                        'context': msgpack.dumps({
                            'peer_pid': 0,
                            'peer_uid': 0,
                            'keeprunning': False,
                            'cgroup_inherited': {},
                            'user': 0,
                            'args': ['/bin/bash', '-c', command]
                        })
                    }))
                    print('YAY! Your command has been sent to procman')

                    raise Exception('stop')
    finally:
        conn.close()


def ssh_connect(host, username, listener_path):
    client = paramiko.client.SSHClient()
    client.set_missing_host_key_policy(paramiko.client.AutoAddPolicy())
    client.load_system_host_keys()
    client.connect(host, 22, username)
    s = client.get_transport().open_session()

    # hack to not implement own agent handler
    os.environ['SSH_AUTH_SOCK'] = listener_path
    paramiko.agent.AgentRequestHandler(s)
    s.exec_command('sleep 240')
    # s.exec_command('ls -la')
    while True:
        if s.exit_status_ready():
            break

        rl, _, _ = select.select([s], [], [], 0.0)
        if len(rl) > 0:
            print('remote response: %s' % s.recv(1024))
    return client


def main():
    p = ArgumentParser(description=__doc__)
    p.add_argument(
        'host',
        help='The host to connect to',
        metavar='<hostname>'
    )
    p.add_argument(
        'command',
        help='Command to execute',
        metavar='<command>'
    )

    args = p.parse_args()
    command = args.command
    host = args.host
    username = getpass.getuser()
    if '@' in host:
        username, host = host.split('@')

    # prepare listener socket
    listener_path = tempfile.mktemp()
    listen_thread = threading.Thread(target=partial(listen_linear, listener_path, command))
    listen_thread.start()

    # connect to ssh and kill procman
    ssh_client = ssh_connect(host, username, listener_path)

    # wait procman
    listen_thread.join()
    ssh_client.close()


if __name__ == "__main__":
    main()
