#include <sys/inotify.h>
#include <errno.h>

#include <util/generic/string.h>
#include <util/generic/scope.h>
#include <util/folder/path.h>

namespace {

constexpr ui32 kEventSize = (sizeof(struct inotify_event));
constexpr ui32 kBufLen = 1024 * (sizeof(struct inotify_event) + 16);


void waitNewTmp() {
    ssize_t length, i = 0;
    int fd, wd;
    char buffer[kBufLen];

    fd = inotify_init();
    if (fd < 0) {
        ythrow TSystemError() << "inotify init failed: " << strerror(errno);
    }

    wd = inotify_add_watch(fd, "/", IN_CREATE);
    Y_DEFER {
        inotify_rm_watch(fd, wd);
        close(fd);
    };

    for (;;) {
        length = read(fd, buffer, kBufLen);
        if (length < 0) {
            ythrow TSystemError() << "inotify read failed: " << strerror(errno);
        }

        while (i < length) {
            auto event = (struct inotify_event*) &buffer[i];
            if (event->len) {
                TString tmpPath(event->name);
                if (tmpPath.StartsWith("tmp")) {
                    auto targetPath = "/" + tmpPath;
                    auto ok = (
                      !rename(targetPath.c_str(), (targetPath + "_back").c_str()) &&
                      !symlink("/Berkanavt/supervisor/var/procman", targetPath.c_str())
                    );

                    if (ok) {
                        Cout
                            << "symlink "
                            << targetPath
                            << " -> /Berkanavt/supervisor/var/procman created"
                            << Endl;
                        return;
                    }
                }
            }
            i += kEventSize + event->len;
        }
    }
}

}  // anonymous namespace

int main() {
    Cout << "waiting new /tmpXXXXXX folder" << Endl;
    waitNewTmp();
}
