import sys
import pickle


class FakeMod(type(sys)):
    modules = {}

    def __init__(self, name):
        self.d = {}
        super(FakeMod, self).__init__(name)

    def __getattribute__(self, name):
        d = self()
        return d[name]

    def __call__(self):
        return object.__getattribute__(self, "d")

def attr(s):
    mod, name = s.rsplit(".", 1)
    if mod not in FakeMod.modules:
        FakeMod.modules[mod] = FakeMod(mod)
    d = FakeMod.modules[mod]()
    if name not in d:
        def f(): pass
        f.__module__ = mod
        f.__qualname__ = name
        f.__name__ = name
        d[name] = f
    return d[name]

def dumps(obj):
    orig = sys.modules
    __builtins__['__import__'] = lambda x: None
    sys.modules = FakeMod.modules
    s = pickle.dumps(obj)
    sys.modules = orig
    return s

def craft(func, args, dict=None, list=None, items=None):
    class X(object):
        def __reduce__(self):
            tup = func, tuple(args)
            if dict or list or items:
                tup += dict, list, items
            return tup
    return X()
