CURRENT_VERSION = 13    # new field: envelope.msgs is a list


def parse_message(data):
    v, d = data
    if isinstance(v, int):
        return parse_new_format(v, d)
    elif isinstance(v, six.string_types):
        return v, d
    else:
        raise RuntimeError("Unsupported format version: %r" % (v,))


def parse_new_format(version, data):
    if 10 <= version < 20:
        if version < CURRENT_VERSION:
            return convert_format_from(version, data)
        else:
            return data[0], data[1]
    else:
        raise RuntimeError('Unsupported format version: %s' % (version,))


def convert_format_from(old_version, data):
    # from 10 to 11
    cmd, env = data[0], data[1]
    env.msg = env.task

    # from 11 to 12
    if hasattr(env, 'data') and env.msg['type'] == 'heartbeat':
        env.msg['next'] = env.data

    # from 12 to 13
    if not hasattr(env, 'msgs'):
        env.msgs = [env.msg]

    return cmd, env
