#include "options.h"

#include <sys/inotify.h>
#include <errno.h>

#include <util/generic/string.h>
#include <util/generic/scope.h>
#include <util/folder/path.h>


using namespace NPortoshellReplacer;

namespace {

constexpr ui32 kEventSize = (sizeof(struct inotify_event));
constexpr ui32 kBufLen = 1024 * (sizeof(struct inotify_event) + 16);


TFsPath waitHome() {
    ssize_t length, i = 0;
    int fd, wd;
    char buffer[kBufLen];

    fd = inotify_init();
    if (fd < 0) {
        ythrow TSystemError() << "inotify init failed: " << strerror(errno);
    }

    wd = inotify_add_watch(fd, "/", IN_CREATE);
    Y_DEFER {
        inotify_rm_watch(fd, wd);
        close(fd);
    };

    for (;;) {
        length = read(fd, buffer, kBufLen);
        if (length < 0) {
            ythrow TSystemError() << "inotify read failed: " << strerror(errno);
        }

        while (i < length) {
            auto event = (struct inotify_event*) &buffer[i];
            if (event->len) {
                TString homePath(event->name);
                Cout << homePath << Endl;
                if (homePath.StartsWith("home")) {
                    return "/" + homePath;
                }
            }
            i += kEventSize + event->len;
        }
    }
}

}  // anonymous namespace

int main(int argc, char** argv) {
    auto opts = TProgramOptions::Parse(argc, argv);

    Cout << "waiting new /homeXXXXXX folder" << Endl;
    auto homePath = waitHome();
    auto targetPath = homePath / opts.SrcName;
    for (;;) {
        symlink(opts.DstPath.c_str(), targetPath.c_str());
    }
}
