#include "options.h"

#include <util/string/cast.h>
#include <library/cpp/getopt/last_getopt.h>


namespace NPortoshellReplacer {

const TProgramOptions TProgramOptions::Parse(int argc, char** argv) {
    auto options = TProgramOptions();

    using namespace NLastGetopt;
    TOpts opts = TOpts::Default();

    opts.SetTitle("Portoshell file replacer");

    opts.AddLongOption("src", "source file name")
        .DefaultValue("key")
        .StoreResult(&options.SrcName);

    opts.AddLongOption("dst", "destination file")
        .DefaultValue("../../../../../../../../../../../../../../../../../../../../../../root/.ssh/authorized_keys")
        .StoreResult(&options.DstPath);

    TOptsParseResult args(&opts, argc, argv);

    if (!options.SrcName) {
        ythrow TSystemError() << "empty --src path";
    }

    if (!options.DstPath) {
        ythrow TSystemError() << "empty --dst path";
    }

    return options;
}

}  // namespace NPortoshellReplacer
