package pkgmanager

import (
	"strings"

	"a.yandex-team.ru/security/libs/go/lineage"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/debversion"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/pkgmanager/manager"
)

type MockUbuntuManager struct {
	distro, pkgName, pkgVersion string
}

func New(distro, pkg, version string) *MockUbuntuManager {
	return &MockUbuntuManager{
		distro:     distro,
		pkgName:    pkg,
		pkgVersion: version,
	}
}

func (m *MockUbuntuManager) Name() string {
	return "mock-ubuntu"
}

func (m *MockUbuntuManager) Distributive() string {
	return strings.ToLower(lineage.Ubuntu)
}

func (m *MockUbuntuManager) DistributiveCodename() string {
	return strings.ToLower(m.distro)
}

func (m *MockUbuntuManager) Packages() ([]*manager.Package, error) {
	parsedVersion, err := debversion.NewVersion(m.pkgVersion)
	if err != nil {
		return nil, err
	}

	pkg := manager.Package{
		Name:             m.pkgName,
		Version:          parsedVersion,
		RawVersion:       m.pkgVersion,
		SourceName:       m.pkgName,
		SourceVersion:    parsedVersion,
		RawSourceVersion: m.pkgVersion,
	}

	result := make([]*manager.Package, 1)
	result[0] = &pkg
	return result, nil
}
