package commands

import (
	"fmt"
	"strconv"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/pocs/ycloud/certorium/crt"
)

var getArgs struct {
	ID int
}

var getCmd = &cobra.Command{
	Use: "get",
	RunE: func(_ *cobra.Command, args []string) error {
		if getArgs.ID <= 0 {
			return fmt.Errorf("invalud --id parameter: %d", getArgs.ID)
		}

		body := crt.SessionServiceReq{
			YkCert: ykCert,
		}

		_, err := crt.HTTPClient().R().
			SetBody(body).
			SetPathParam("id", strconv.Itoa(getArgs.ID)).
			Post("api/get_session_certificate/{id}/")

		return err
	},
}

func init() {
	getCmd.PersistentFlags().IntVar(&getArgs.ID, "id", 0, "certificate id")
}
