package commands

import (
	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/pocs/ycloud/certorium/crt"
)

var listArgs struct {
	User string
}

var listCmd = &cobra.Command{
	Use: "list",
	RunE: func(_ *cobra.Command, args []string) error {
		body := crt.SessionServiceReq{
			YkCert: ykCert,
		}

		_, err := crt.HTTPClient().R().
			SetBody(body).
			SetQueryParam("user", listArgs.User).
			Post("/api/list_session_certificate")

		return err
	},
}

func init() {
	listCmd.PersistentFlags().StringVar(&listArgs.User, "user", "", "user query")
}
